/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.metadata;

import ca.uhn.hl7v2.model.Primitive;
import ca.uhn.hl7v2.model.v25.datatype.CX;
import jakarta.xml.bind.annotation.XmlAccessorType;
import jakarta.xml.bind.annotation.XmlAttribute;
import jakarta.xml.bind.annotation.XmlType;
import java.util.Objects;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.CXiAssigningAuthority;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Hl7v2Based;

@XmlAccessorType
@XmlType(name="ReferenceId", propOrder={"id", "assigningAuthority", "idTypeCode"})
public class ReferenceId
extends Hl7v2Based<CX> {
    private static final long serialVersionUID = 6615092850652668283L;
    public static final String ID_TYPE_CODE_UNIQUE_ID = "urn:ihe:iti:xds:2013:uniqueId";
    public static final String ID_TYPE_CODE_ACCESSION = "urn:ihe:iti:xds:2013:accession";
    public static final String ID_TYPE_CODE_REFERRAL = "urn:ihe:iti:xds:2013:referral";
    public static final String ID_TYPE_CODE_ORDER = "urn:ihe:iti:xds:2013:order";
    public static final String ID_TYPE_WORKFLOW_INSTANCE_ID = "urn:ihe:iti:xdw:2013:workflowInstanceId";
    public static final String ID_TYPE_ENCOUNTER_ID = "urn:ihe:iti:xds:2015:encounterId";
    public static final String ID_TYPE_STUDY_INSTANCE_ID = "urn:ihe:iti:xds:2016:studyInstanceUID";

    public ReferenceId() {
        super(new CX(MESSAGE));
    }

    public ReferenceId(CX cx) {
        super(cx);
    }

    public ReferenceId(String id, CXiAssigningAuthority assigningAuthority, String idTypeCode) {
        this();
        this.setId(id);
        this.setAssigningAuthority(assigningAuthority);
        this.setIdTypeCode(idTypeCode);
    }

    public static ReferenceId parse(String hl7String) {
        return Hl7v2Based.parse(hl7String, ReferenceId.class);
    }

    @XmlAttribute
    public String getId() {
        return ((CX)this.getHapiObject()).getCx1_IDNumber().getValue();
    }

    public void setId(String id) {
        ReferenceId.setValue((Primitive)((CX)this.getHapiObject()).getCx1_IDNumber(), id);
    }

    public CXiAssigningAuthority getAssigningAuthority() {
        CXiAssigningAuthority assigningAuthority = new CXiAssigningAuthority(((CX)this.getHapiObject()).getCx4_AssigningAuthority());
        return assigningAuthority.isEmpty() ? null : assigningAuthority;
    }

    public void setAssigningAuthority(CXiAssigningAuthority assigningAuthority) {
        ReferenceId.setAssigningAuthority(assigningAuthority, ((CX)this.getHapiObject()).getCx4_AssigningAuthority());
    }

    @XmlAttribute
    public String getIdTypeCode() {
        return ((CX)this.getHapiObject()).getCx5_IdentifierTypeCode().getValue();
    }

    public void setIdTypeCode(String idTypeCode) {
        ReferenceId.setValue((Primitive)((CX)this.getHapiObject()).getCx5_IdentifierTypeCode(), idTypeCode);
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        ReferenceId that = (ReferenceId)o;
        return Objects.equals(this.getAssigningAuthority(), that.getAssigningAuthority()) && Objects.equals(this.getId(), that.getId()) && Objects.equals(this.getIdTypeCode(), that.getIdTypeCode());
    }

    public int hashCode() {
        return Objects.hash(this.getId(), this.getIdTypeCode(), this.getAssigningAuthority());
    }

    public String toString() {
        return "ReferenceId(id=" + this.getId() + ", assigningAuthority=" + this.getAssigningAuthority() + ", idTypeCode=" + this.getIdTypeCode() + ")";
    }
}

