/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30;

import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLSlot;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLSlotList;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.EbXMLFactory30;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.EbXMLSlot30;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rim.SlotType1;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rim.ValueListType;

public class EbXMLSlotList30
implements EbXMLSlotList {
    private final List<SlotType1> slotListObj;

    public EbXMLSlotList30(List<SlotType1> slotListObj) {
        this.slotListObj = Objects.requireNonNull(slotListObj, "slotListObj cannot be null");
    }

    @Override
    public void addSlot(String slotName, String ... slotValues) {
        if (slotValues == null || slotValues.length == 0) {
            return;
        }
        ValueListType valueList = EbXMLFactory30.RIM_FACTORY.createValueListType();
        List<String> values = valueList.getValue();
        for (String slotValue : slotValues) {
            if (slotValue == null) continue;
            values.add(slotValue);
        }
        SlotType1 slotEbXML = EbXMLFactory30.RIM_FACTORY.createSlotType1();
        slotEbXML.setName(slotName);
        slotEbXML.setValueList(valueList);
        EbXMLSlot30 slot = new EbXMLSlot30(slotEbXML);
        if (!slot.getValueList().isEmpty()) {
            this.slotListObj.add(slotEbXML);
        }
    }

    @Override
    public List<String> getSlotValues(String slotName) {
        Objects.requireNonNull(slotName, "slotName cannot be null");
        for (SlotType1 slot30 : this.slotListObj) {
            if (!slotName.equals(slot30.getName())) continue;
            return slot30.getValueList().getValue();
        }
        return Collections.emptyList();
    }

    @Override
    public String getSingleSlotValue(String slotName) {
        List<String> slotValues = this.getSlotValues(slotName);
        return !slotValues.isEmpty() ? slotValues.get(0) : null;
    }

    @Override
    public List<EbXMLSlot> getSlots() {
        return this.slotListObj.stream().map(EbXMLSlot30::new).collect(Collectors.toList());
    }

    @Override
    public List<EbXMLSlot> getSlots(String slotName) {
        Objects.requireNonNull(slotName, "slotName cannot be null");
        return this.slotListObj.stream().filter(slot30 -> slotName.equals(slot30.getName())).map(EbXMLSlot30::new).collect(Collectors.toList());
    }
}

