/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryError;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRetrieveDocumentSetResponse;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.EbXMLFactory30;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.EbXMLRegistryError30;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.RetrieveDocumentSetResponseType;
import org.openehealth.ipf.commons.ihe.xds.core.requests.DocumentReference;
import org.openehealth.ipf.commons.ihe.xds.core.responses.RetrievedDocument;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Status;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rs.RegistryError;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rs.RegistryErrorList;

public class EbXMLRetrieveDocumentSetResponse30
implements EbXMLRetrieveDocumentSetResponse<RetrieveDocumentSetResponseType> {
    private final RetrieveDocumentSetResponseType response;

    public EbXMLRetrieveDocumentSetResponse30(RetrieveDocumentSetResponseType response) {
        this.response = Objects.requireNonNull(response, "response cannot be null");
    }

    @Override
    public RetrieveDocumentSetResponseType getInternal() {
        return this.response;
    }

    @Override
    public List<RetrievedDocument> getDocuments() {
        ArrayList<RetrievedDocument> docs = new ArrayList<RetrievedDocument>();
        for (RetrieveDocumentSetResponseType.DocumentResponse documentResponse : this.response.getDocumentResponse()) {
            DocumentReference requestData = new DocumentReference();
            requestData.setDocumentUniqueId(documentResponse.getDocumentUniqueId());
            requestData.setHomeCommunityId(documentResponse.getHomeCommunityId());
            requestData.setRepositoryUniqueId(documentResponse.getRepositoryUniqueId());
            RetrievedDocument doc = EbXMLRetrieveDocumentSetResponse30.getRetrievedDocument(documentResponse, requestData);
            docs.add(doc);
        }
        return docs;
    }

    private static RetrievedDocument getRetrievedDocument(RetrieveDocumentSetResponseType.DocumentResponse documentResponse, DocumentReference requestData) {
        RetrievedDocument doc = new RetrievedDocument();
        doc.setDataHandler(documentResponse.getDocument());
        doc.setRequestData(requestData);
        doc.setNewRepositoryUniqueId(documentResponse.getNewRepositoryUniqueId());
        doc.setNewDocumentUniqueId(documentResponse.getNewDocumentUniqueId());
        if (documentResponse.getMimeType() != null) {
            doc.setMimeType(documentResponse.getMimeType());
        } else if (documentResponse.getDocument() != null) {
            doc.setMimeType(documentResponse.getDocument().getContentType());
        }
        return doc;
    }

    @Override
    public void setDocuments(List<RetrievedDocument> documents) {
        this.response.getDocumentResponse().clear();
        if (documents != null) {
            for (RetrievedDocument doc : documents) {
                RetrieveDocumentSetResponseType.DocumentResponse documentResponse = new RetrieveDocumentSetResponseType.DocumentResponse();
                documentResponse.setDocument(doc.getDataHandler());
                documentResponse.setNewRepositoryUniqueId(doc.getNewRepositoryUniqueId());
                documentResponse.setNewDocumentUniqueId(doc.getNewDocumentUniqueId());
                if (doc.getMimeType() != null) {
                    documentResponse.setMimeType(doc.getMimeType());
                } else if (doc.getDataHandler() != null) {
                    documentResponse.setMimeType(doc.getDataHandler().getContentType());
                }
                DocumentReference requestData = doc.getRequestData();
                if (requestData != null) {
                    documentResponse.setDocumentUniqueId(requestData.getDocumentUniqueId());
                    documentResponse.setHomeCommunityId(requestData.getHomeCommunityId());
                    documentResponse.setRepositoryUniqueId(requestData.getRepositoryUniqueId());
                }
                this.response.getDocumentResponse().add(documentResponse);
            }
        }
    }

    @Override
    public void setStatus(Status status) {
        if (this.response.getRegistryResponse() != null) {
            this.response.getRegistryResponse().setStatus(Status.getOpcode30(status));
        }
    }

    @Override
    public Status getStatus() {
        Status status = null;
        if (this.response.getRegistryResponse() != null) {
            status = Status.valueOfOpcode(this.response.getRegistryResponse().getStatus());
        }
        return status;
    }

    @Override
    public List<EbXMLRegistryError> getErrors() {
        RegistryErrorList list = this.response.getRegistryResponse().getRegistryErrorList();
        if (list == null) {
            return Collections.emptyList();
        }
        return list.getRegistryError().stream().map(EbXMLRegistryError30::new).collect(Collectors.toList());
    }

    @Override
    public void setErrors(List<EbXMLRegistryError> errors) {
        RegistryErrorList value = EbXMLFactory30.RS_FACTORY.createRegistryErrorList();
        this.response.getRegistryResponse().setRegistryErrorList(value);
        List<RegistryError> list = value.getRegistryError();
        list.addAll(errors.stream().map(error -> ((EbXMLRegistryError30)error).getInternal()).toList());
    }
}

