/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30;

import java.util.List;
import java.util.Objects;
import java.util.UUID;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLClassification;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLExternalIdentifier;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLObjectLibrary;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLRegistryObject;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.EbXMLSlot;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.EbXMLClassification30;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.EbXMLExternalIdentifier30;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.EbXMLFactory30;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.EbXMLInternationalString30;
import org.openehealth.ipf.commons.ihe.xds.core.ebxml.ebxml30.EbXMLSlotList30;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.LocalizedString;
import org.openehealth.ipf.commons.ihe.xds.core.metadata.Version;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rim.ClassificationType;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rim.ExternalIdentifierType;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rim.IdentifiableType;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rim.InternationalStringType;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rim.RegistryObjectType;
import org.openehealth.ipf.commons.ihe.xds.core.stub.ebrs30.rim.VersionInfoType;

public abstract class EbXMLRegistryObject30<E extends RegistryObjectType>
implements EbXMLRegistryObject {
    private final E registryEntry;
    private final EbXMLObjectLibrary objectLibrary;

    protected EbXMLRegistryObject30(E registryEntry, EbXMLObjectLibrary objectLibrary) {
        this.registryEntry = (RegistryObjectType)Objects.requireNonNull(registryEntry, "registryEntry cannot be null");
        this.objectLibrary = Objects.requireNonNull(objectLibrary, "objectLibrary cannot be null");
    }

    protected EbXMLObjectLibrary getObjectLibrary() {
        return this.objectLibrary;
    }

    @Override
    public void addClassification(EbXMLClassification classification, String scheme) {
        Objects.requireNonNull(scheme, "scheme cannot be null");
        if (classification != null) {
            classification.setClassificationScheme(scheme);
            classification.setClassifiedObject(((IdentifiableType)this.registryEntry).getId());
            classification.assignUniqueId();
            List<ClassificationType> classifications = ((RegistryObjectType)this.registryEntry).getClassification();
            classifications.add(((EbXMLClassification30)classification).getInternal());
        }
    }

    @Override
    public void addExternalIdentifier(String value, String scheme, String name) {
        Objects.requireNonNull(name, "name cannot be null");
        Objects.requireNonNull(scheme, "scheme cannot be null");
        if (value != null) {
            ExternalIdentifierType identifier = EbXMLFactory30.RIM_FACTORY.createExternalIdentifierType();
            EbXMLExternalIdentifier30 externalIdentifier = new EbXMLExternalIdentifier30(identifier);
            externalIdentifier.setValue(value);
            externalIdentifier.setIdentificationScheme(scheme);
            externalIdentifier.setRegistryObject(((IdentifiableType)this.registryEntry).getId());
            externalIdentifier.setId("urn:uuid:" + UUID.randomUUID());
            LocalizedString localized = new LocalizedString(name, null, null);
            externalIdentifier.setName(new EbXMLInternationalString30(localized));
            List<ExternalIdentifierType> externalIdentifiers = ((RegistryObjectType)this.registryEntry).getExternalIdentifier();
            externalIdentifiers.add(identifier);
        }
    }

    @Override
    public List<EbXMLClassification> getClassifications() {
        List<ClassificationType> classifications = ((RegistryObjectType)this.registryEntry).getClassification();
        return classifications.stream().map(EbXMLClassification30::new).collect(Collectors.toList());
    }

    @Override
    public List<EbXMLClassification> getClassifications(String scheme) {
        Objects.requireNonNull(scheme, "scheme cannot be null");
        return ((RegistryObjectType)this.registryEntry).getClassification().stream().filter(classification -> scheme.equals(classification.getClassificationScheme())).map(EbXMLClassification30::new).collect(Collectors.toList());
    }

    @Override
    public LocalizedString getDescription() {
        InternationalStringType description = ((RegistryObjectType)this.registryEntry).getDescription();
        EbXMLInternationalString30 encapsulated = new EbXMLInternationalString30(description);
        return encapsulated.getSingleLocalizedString();
    }

    @Override
    public String getExternalIdentifierValue(String scheme) {
        for (ExternalIdentifierType identifier : ((RegistryObjectType)this.registryEntry).getExternalIdentifier()) {
            if (!scheme.equals(identifier.getIdentificationScheme())) continue;
            return identifier.getValue();
        }
        return null;
    }

    @Override
    public List<EbXMLExternalIdentifier> getExternalIdentifiers() {
        List<ExternalIdentifierType> externalIdentifiers = ((RegistryObjectType)this.registryEntry).getExternalIdentifier();
        return externalIdentifiers.stream().map(EbXMLExternalIdentifier30::new).collect(Collectors.toList());
    }

    @Override
    public String getId() {
        return ((IdentifiableType)this.registryEntry).getId();
    }

    @Override
    public void setId(String id) {
        ((IdentifiableType)this.registryEntry).setId(id);
    }

    @Override
    public String getLid() {
        return ((RegistryObjectType)this.registryEntry).getLid();
    }

    @Override
    public void setLid(String lid) {
        ((RegistryObjectType)this.registryEntry).setLid(lid);
    }

    @Override
    public Version getVersionInfo() {
        VersionInfoType versionInfo = ((RegistryObjectType)this.registryEntry).getVersionInfo();
        if (versionInfo == null) {
            return null;
        }
        return new Version(versionInfo.getVersionName(), versionInfo.getComment());
    }

    @Override
    public void setVersionInfo(Version version) {
        VersionInfoType versionInfo = null;
        if (version != null) {
            versionInfo = EbXMLFactory30.RIM_FACTORY.createVersionInfoType();
            versionInfo.setVersionName(version.getVersionName());
            versionInfo.setComment(version.getComment());
        }
        ((RegistryObjectType)this.registryEntry).setVersionInfo(versionInfo);
    }

    @Override
    public LocalizedString getName() {
        InternationalStringType name = ((RegistryObjectType)this.registryEntry).getName();
        EbXMLInternationalString30 encapsulated = new EbXMLInternationalString30(name);
        return encapsulated.getSingleLocalizedString();
    }

    @Override
    public String getObjectType() {
        return ((RegistryObjectType)this.registryEntry).getObjectType();
    }

    @Override
    public EbXMLClassification getSingleClassification(String scheme) {
        List<EbXMLClassification> filtered = this.getClassifications(scheme);
        return filtered.isEmpty() ? null : filtered.get(0);
    }

    @Override
    public void setDescription(LocalizedString description) {
        EbXMLInternationalString30 encapsulated = new EbXMLInternationalString30(description);
        ((RegistryObjectType)this.registryEntry).setDescription(encapsulated.getInternal());
    }

    @Override
    public void setName(LocalizedString name) {
        EbXMLInternationalString30 encapsulated = new EbXMLInternationalString30(name);
        ((RegistryObjectType)this.registryEntry).setName(encapsulated.getInternal());
    }

    @Override
    public void setObjectType(String objectType) {
        ((RegistryObjectType)this.registryEntry).setObjectType(objectType);
    }

    @Override
    public String getHome() {
        return ((IdentifiableType)this.registryEntry).getHome();
    }

    @Override
    public void setHome(String home) {
        ((IdentifiableType)this.registryEntry).setHome(home);
    }

    public E getInternal() {
        return this.registryEntry;
    }

    private EbXMLSlotList30 getSlotList() {
        return new EbXMLSlotList30(((IdentifiableType)this.registryEntry).getSlot());
    }

    @Override
    @Generated
    public void addSlot(String slotName, String ... slotValues) {
        this.getSlotList().addSlot(slotName, slotValues);
    }

    @Override
    @Generated
    public List<String> getSlotValues(String slotName) {
        return this.getSlotList().getSlotValues(slotName);
    }

    @Override
    @Generated
    public String getSingleSlotValue(String slotName) {
        return this.getSlotList().getSingleSlotValue(slotName);
    }

    @Override
    @Generated
    public List<EbXMLSlot> getSlots() {
        return this.getSlotList().getSlots();
    }

    @Override
    @Generated
    public List<EbXMLSlot> getSlots(String slotName) {
        return this.getSlotList().getSlots(slotName);
    }
}

