/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.xds.core;

import java.util.Objects;
import org.apache.commons.lang3.Validate;
import org.openehealth.ipf.commons.ihe.xds.core.responses.ErrorCode;
import org.openehealth.ipf.commons.ihe.xds.core.responses.Severity;

public class XdsRuntimeException
extends RuntimeException {
    private final ErrorCode errorCode;
    private final String codeContext;
    private final Severity severity;
    private final String location;

    public XdsRuntimeException(ErrorCode errorCode, String codeContext, Severity severity, String location) {
        this.errorCode = Objects.requireNonNull(errorCode);
        this.codeContext = (String)Validate.notEmpty((CharSequence)codeContext);
        this.severity = Objects.requireNonNull(severity);
        this.location = location;
    }

    public ErrorCode getErrorCode() {
        return this.errorCode;
    }

    public String getCodeContext() {
        return this.codeContext;
    }

    public Severity getSeverity() {
        return this.severity;
    }

    public String getLocation() {
        return this.location;
    }

    @Override
    public String getMessage() {
        StringBuilder sb = new StringBuilder().append(this.severity == Severity.ERROR ? "Error " : "Warning ").append(this.errorCode.getOpcode()).append(": ").append(this.codeContext);
        if (this.location != null) {
            sb.append(". Location: ").append(this.location);
        }
        return sb.toString();
    }
}

