/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.utils;

import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.apache.cxf.message.Exchange;
import org.apache.cxf.message.Message;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.w3c.dom.Element;
import org.w3c.dom.Node;

public abstract class SoapUtils {
    private static final Logger log = LoggerFactory.getLogger(SoapUtils.class);
    public static final Set<String> WS_ADDRESSING_NS_URIS = new HashSet<String>();
    public static final Set<String> SOAP_NS_URIS;

    private SoapUtils() {
        throw new UnsupportedOperationException("Utility class cannot be instantiated");
    }

    public static String extractSoapBody(String soapEnvelope) {
        try {
            int pos1 = soapEnvelope.lastIndexOf("<");
            pos1 = soapEnvelope.lastIndexOf("<", pos1 - 1);
            int pos5 = soapEnvelope.indexOf(">", pos1);
            if (soapEnvelope.charAt(pos5 - 1) == '/') {
                return "";
            }
            int pos2 = soapEnvelope.indexOf(":", pos1);
            String soapPrefix = pos2 == -1 || pos5 < pos2 ? "" : soapEnvelope.substring(pos1 + 2, pos2 + 1);
            String bodyElementStart = "<" + soapPrefix + "Body";
            int pos3 = soapEnvelope.indexOf(bodyElementStart);
            int pos4 = soapEnvelope.indexOf(62, pos3 + bodyElementStart.length());
            return soapEnvelope.substring(pos4 + 1, pos1);
        }
        catch (Exception e) {
            log.error("Invalid contents, probably not a SOAP Envelope in the parameter", (Throwable)e);
            return soapEnvelope;
        }
    }

    public static Exception extractOutgoingException(Exchange exchange) {
        Message outFaultMessage = exchange.getOutFaultMessage();
        return outFaultMessage != null ? (Exception)outFaultMessage.getContent(Exception.class) : null;
    }

    public static String extractOutgoingPayload(Exchange exchange) {
        try {
            return (String)((List)exchange.getOutMessage().getContent(List.class)).get(0);
        }
        catch (Exception e) {
            return null;
        }
    }

    public static Element getElementNS(Element root, Set<String> nsUris, String wantedLocalName) {
        if (root == null) {
            return null;
        }
        for (Node node = root.getFirstChild(); node != null; node = node.getNextSibling()) {
            if (!(node instanceof Element) || !nsUris.contains(node.getNamespaceURI()) || !node.getLocalName().equals(wantedLocalName)) continue;
            return (Element)node;
        }
        return null;
    }

    static {
        WS_ADDRESSING_NS_URIS.add("http://www.w3.org/2005/08/addressing");
        WS_ADDRESSING_NS_URIS.add("http://schemas.xmlsoap.org/ws/2004/03/addressing");
        WS_ADDRESSING_NS_URIS.add("http://schemas.xmlsoap.org/ws/2004/08/addressing");
        SOAP_NS_URIS = new HashSet<String>();
        SOAP_NS_URIS.add("http://schemas.xmlsoap.org/soap/envelope/");
        SOAP_NS_URIS.add("http://www.w3.org/2003/05/soap-envelope");
    }
}

