/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.cxf.payload;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.UnsupportedEncodingException;
import org.apache.cxf.helpers.IOUtils;
import org.apache.cxf.interceptor.AttachmentInInterceptor;
import org.apache.cxf.interceptor.Fault;
import org.apache.cxf.interceptor.Interceptor;
import org.apache.cxf.interceptor.StaxInInterceptor;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.apache.cxf.wsdl.interceptors.DocLiteralInInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.StringPayloadHolder;
import org.openehealth.ipf.commons.ihe.ws.utils.SoapUtils;

public class InPayloadExtractorInterceptor
extends AbstractPhaseInterceptor<Message> {
    private final StringPayloadHolder.PayloadType payloadType;

    public InPayloadExtractorInterceptor(StringPayloadHolder.PayloadType payloadType) {
        super(InPayloadExtractorInterceptor.class.getName() + "-" + payloadType, InPayloadExtractorInterceptor.getPhase(payloadType));
        this.payloadType = payloadType;
        switch (payloadType) {
            case HTTP: {
                this.addBefore(AttachmentInInterceptor.class.getName());
                break;
            }
            case SOAP_BODY: {
                this.addAfter(AttachmentInInterceptor.class.getName());
                this.addBefore(StaxInInterceptor.class.getName());
            }
        }
    }

    private static String getPhase(StringPayloadHolder.PayloadType payloadType) {
        return switch (payloadType) {
            default -> throw new IncompatibleClassChangeError();
            case StringPayloadHolder.PayloadType.HTTP -> "receive";
            case StringPayloadHolder.PayloadType.SOAP_BODY -> "pre-stream";
        };
    }

    public void handleMessage(Message message) {
        StringPayloadHolder payloadHolder;
        String payload;
        byte[] bytes;
        if (this.isGET(message)) {
            return;
        }
        try {
            InputStream stream = (InputStream)message.getContent(InputStream.class);
            bytes = IOUtils.readBytesFromStream((InputStream)stream);
            message.setContent(InputStream.class, (Object)new ByteArrayInputStream(bytes));
        }
        catch (IOException e) {
            throw new RuntimeException("Error when extracting payload", e);
        }
        try {
            String charsetName = (String)message.get((Object)Message.ENCODING);
            payload = charsetName != null ? new String(bytes, charsetName) : new String(bytes);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        if (this.payloadType == StringPayloadHolder.PayloadType.SOAP_BODY) {
            payload = SoapUtils.extractSoapBody(payload);
        }
        if ((payloadHolder = (StringPayloadHolder)message.getContent(StringPayloadHolder.class)) == null) {
            payloadHolder = new StringPayloadHolder();
            message.setContent(StringPayloadHolder.class, (Object)payloadHolder);
        }
        payloadHolder.put(this.payloadType, payload);
        if (this.payloadType == StringPayloadHolder.PayloadType.HTTP) {
            message.getInterceptorChain().add((Interceptor)new DropHttpPayloadInterceptor());
        }
    }

    private static class DropHttpPayloadInterceptor
    extends AbstractPhaseInterceptor<Message> {
        private DropHttpPayloadInterceptor() {
            super("unmarshal");
            this.addAfter(DocLiteralInInterceptor.class.getName());
        }

        public void handleMessage(Message message) throws Fault {
            StringPayloadHolder payloadHolder = (StringPayloadHolder)message.getContent(StringPayloadHolder.class);
            if (payloadHolder != null) {
                payloadHolder.remove(StringPayloadHolder.PayloadType.HTTP);
            }
            message.removeContent(InputStream.class);
        }
    }
}

