/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.cxf.audit;

import jakarta.servlet.http.HttpServletRequest;
import java.security.cert.Certificate;
import java.security.cert.X509Certificate;
import java.util.List;
import java.util.Objects;
import javax.naming.ldap.LdapName;
import javax.naming.ldap.Rdn;
import javax.security.auth.x500.X500Principal;
import lombok.Generated;
import org.apache.cxf.binding.soap.SoapMessage;
import org.apache.cxf.headers.Header;
import org.apache.cxf.message.Message;
import org.apache.cxf.security.transport.TLSSessionInfo;
import org.apache.cxf.ws.addressing.AddressingProperties;
import org.apache.cxf.ws.addressing.AttributedURIType;
import org.apache.cxf.ws.addressing.EndpointReferenceType;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.ws.InterceptorUtils;
import org.openehealth.ipf.commons.ihe.ws.cxf.AbstractSafeInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDataset;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDatasetEnricher;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AbstractAuditInterceptor<T extends WsAuditDataset>
extends AbstractSafeInterceptor {
    private static final Logger log = LoggerFactory.getLogger(AbstractAuditInterceptor.class);
    public static final String DATASET_CONTEXT_KEY = AbstractAuditInterceptor.class.getName() + ".DATASET";
    private final AuditStrategy<T> auditStrategy;
    private final AuditContext auditContext;

    protected AbstractAuditInterceptor(String phase, AuditStrategy<T> auditStrategy, AuditContext auditContext) {
        super(phase);
        this.auditStrategy = Objects.requireNonNull(auditStrategy);
        this.auditContext = Objects.requireNonNull(auditContext);
    }

    protected T getAuditDataset(SoapMessage message) {
        WsAuditDataset auditDataset = (WsAuditDataset)((Object)InterceptorUtils.findContextualProperty((Message)message, DATASET_CONTEXT_KEY));
        if (auditDataset == null) {
            auditDataset = (WsAuditDataset)this.getAuditStrategy().createAuditDataset();
            if (auditDataset == null) {
                log.warn("Cannot obtain audit dataset instance, NPE is pending");
                return null;
            }
            message.getExchange().put((Object)DATASET_CONTEXT_KEY, (Object)auditDataset);
        }
        return (T)((Object)auditDataset);
    }

    protected AuditStrategy<T> getAuditStrategy() {
        return this.auditStrategy;
    }

    protected static void extractUserIdFromWSAddressing(SoapMessage message, boolean isInbound, boolean inverseWsaDirection, WsAuditDataset auditDataset) {
        AddressingProperties wsaProperties = (AddressingProperties)message.get((Object)(isInbound ? "jakarta.xml.ws.addressing.context.inbound" : "jakarta.xml.ws.addressing.context.outbound"));
        if (wsaProperties != null) {
            AttributedURIType address = null;
            if (inverseWsaDirection) {
                address = wsaProperties.getTo();
            } else {
                EndpointReferenceType replyTo = wsaProperties.getReplyTo();
                if (replyTo != null) {
                    address = replyTo.getAddress();
                }
            }
            if (address != null) {
                auditDataset.setSourceUserId(address.getValue());
            }
        }
        if (auditDataset.getSourceUserId() == null) {
            log.info("Missing WS-Addressing headers");
            auditDataset.setSourceUserId("unknown");
        }
    }

    protected void enrichAuditDatasetFromRequest(SoapMessage message, Header.Direction headerDirection, WsAuditDataset auditDataset) {
        WsAuditDatasetEnricher enricher = (WsAuditDatasetEnricher)this.auditContext.getWsAuditDatasetEnricher();
        if (enricher != null) {
            enricher.enrichAuditDatasetFromRequest(message, headerDirection, auditDataset);
        }
    }

    protected void enrichAuditDatasetFromResponse(SoapMessage message, Header.Direction headerDirection, WsAuditDataset auditDataset) {
        WsAuditDatasetEnricher enricher = (WsAuditDatasetEnricher)this.auditContext.getWsAuditDatasetEnricher();
        if (enricher != null) {
            enricher.enrichAuditDatasetFromResponse(message, headerDirection, auditDataset);
        }
    }

    protected static void extractAddressesFromServletRequest(SoapMessage message, WsAuditDataset auditDataset) {
        HttpServletRequest request = (HttpServletRequest)message.get((Object)"HTTP.REQUEST");
        auditDataset.setRemoteAddress(request.getRemoteAddr());
        auditDataset.setLocalAddress(request.getServerName());
        auditDataset.setDestinationUserId(request.getRequestURL().toString());
    }

    protected static void extractClientCertificateCommonName(SoapMessage message, WsAuditDataset auditDataset) {
        Certificate[] certificates;
        TLSSessionInfo request = (TLSSessionInfo)message.get(TLSSessionInfo.class);
        if (request != null && (certificates = request.getPeerCertificates()) != null && certificates.length > 0) {
            try {
                X509Certificate certificate = (X509Certificate)certificates[0];
                X500Principal principal = certificate.getSubjectX500Principal();
                String dn = principal.getName();
                LdapName ldapDN = new LdapName(dn);
                for (Rdn rdn : ldapDN.getRdns()) {
                    if (!rdn.getType().equalsIgnoreCase("CN")) continue;
                    auditDataset.setSourceUserName((String)rdn.getValue());
                    break;
                }
            }
            catch (Exception e) {
                log.info("Could not extract CN from client certificate", (Throwable)e);
            }
        }
    }

    protected static Object extractPojo(Message message) {
        List list = (List)message.getContent(List.class);
        return list == null || list.isEmpty() ? null : list.get(0);
    }

    @Generated
    public AuditContext getAuditContext() {
        return this.auditContext;
    }
}

