/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.correlation;

import java.util.Objects;
import org.openehealth.ipf.commons.ihe.ws.correlation.AsynchronyCorrelator;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDataset;
import org.springframework.cache.Cache;
import org.springframework.cache.CacheManager;

public class SpringCacheAsynchronyCorrelator<AuditDatasetType extends WsAuditDataset>
implements AsynchronyCorrelator<AuditDatasetType> {
    private static final String ASYNCHRONY_CORRELATOR_CACHE = "asynchronyCorrelatorCache";
    private static final String SERVICE_ENDPOINT_URI_SUFFIX = ".serviceEndpoint";
    private static final String CORRELATION_KEY_SUFFIX = ".correlationKey";
    private static final String AUDIT_DATASET_SUFFIX = ".auditDataset";
    private static final String ALTERNATIVE_KEY_SUFFIX = ".alternativeKey";
    private static final String ALTERNATIVE_KEYS_SUFFIX = ".alternativeKeys";
    private final Cache cache;

    public SpringCacheAsynchronyCorrelator(CacheManager cacheManager) {
        this.cache = cacheManager.getCache(ASYNCHRONY_CORRELATOR_CACHE);
    }

    @Override
    public void storeServiceEndpointUri(String messageId, String serviceEndpointUri) {
        this.cache.put((Object)(messageId + SERVICE_ENDPOINT_URI_SUFFIX), (Object)Objects.requireNonNull(serviceEndpointUri, "service endpoint URI"));
    }

    @Override
    public void storeCorrelationKey(String messageId, String correlationKey) {
        this.cache.put((Object)(messageId + CORRELATION_KEY_SUFFIX), (Object)Objects.requireNonNull(correlationKey, "correlation key"));
    }

    @Override
    public void storeAuditDataset(String messageId, WsAuditDataset auditDataset) {
        this.cache.put((Object)(messageId + AUDIT_DATASET_SUFFIX), (Object)Objects.requireNonNull(auditDataset, "audit dataset"));
    }

    @Override
    public String getServiceEndpointUri(String messageId) {
        return (String)this.cache.get((Object)(messageId + SERVICE_ENDPOINT_URI_SUFFIX), String.class);
    }

    @Override
    public String getCorrelationKey(String messageId) {
        return (String)this.cache.get((Object)(messageId + CORRELATION_KEY_SUFFIX), String.class);
    }

    @Override
    public AuditDatasetType getAuditDataset(String messageId) {
        Cache.ValueWrapper value = this.cache.get((Object)(messageId + AUDIT_DATASET_SUFFIX));
        return (AuditDatasetType)((Object)(value == null || value.get() == null ? null : (WsAuditDataset)((Object)value.get())));
    }

    @Override
    public void storeAlternativeKeys(String messageId, String ... alternativeKeys) {
        Objects.requireNonNull(alternativeKeys, "alternative keys should be not null");
        for (String key : alternativeKeys) {
            this.cache.put((Object)(key + ALTERNATIVE_KEY_SUFFIX), (Object)messageId);
        }
        this.cache.put((Object)(messageId + ALTERNATIVE_KEYS_SUFFIX), (Object)alternativeKeys);
    }

    @Override
    public String getMessageId(String alternativeKey) {
        return (String)this.cache.get((Object)(alternativeKey + ALTERNATIVE_KEY_SUFFIX), String.class);
    }

    @Override
    public boolean delete(String messageId) {
        String[] alternativeKeys = (String[])this.cache.get((Object)(messageId + ALTERNATIVE_KEYS_SUFFIX), String[].class);
        if (alternativeKeys != null) {
            for (String key : alternativeKeys) {
                this.cache.evict((Object)(key + ALTERNATIVE_KEY_SUFFIX));
            }
        }
        this.cache.evict((Object)(messageId + ALTERNATIVE_KEYS_SUFFIX));
        this.cache.evict((Object)(messageId + CORRELATION_KEY_SUFFIX));
        this.cache.evict((Object)(messageId + AUDIT_DATASET_SUFFIX));
        if (this.cache.get((Object)(messageId + SERVICE_ENDPOINT_URI_SUFFIX)) != null) {
            this.cache.evict((Object)(messageId + SERVICE_ENDPOINT_URI_SUFFIX));
            return true;
        }
        return false;
    }
}

