/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws;

import java.util.Objects;
import org.apache.cxf.frontend.ServerFactoryBean;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.ws.JaxWsServiceFactory;
import org.openehealth.ipf.commons.ihe.ws.WsTransactionConfiguration;
import org.openehealth.ipf.commons.ihe.ws.correlation.AsynchronyCorrelator;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.AuditResponseInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDataset;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.InPayloadExtractorInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.StringPayloadHolder;

public class JaxWsAsyncResponseServiceFactory<AuditDatasetType extends WsAuditDataset>
extends JaxWsServiceFactory<AuditDatasetType> {
    protected final AsynchronyCorrelator<AuditDatasetType> correlator;

    public JaxWsAsyncResponseServiceFactory(WsTransactionConfiguration<AuditDatasetType> wsTransactionConfiguration, String serviceAddress, AuditStrategy<AuditDatasetType> auditStrategy, AuditContext auditContext, InterceptorProvider customInterceptors, AsynchronyCorrelator<AuditDatasetType> correlator) {
        super(wsTransactionConfiguration, serviceAddress, auditStrategy, auditContext, customInterceptors, null);
        Objects.requireNonNull(correlator, "Correlator for asynchronous processing must be set.");
        this.correlator = correlator;
    }

    @Override
    protected void configureInterceptors(ServerFactoryBean svrFactory) {
        super.configureInterceptors(svrFactory);
        if (this.auditStrategy != null) {
            if (this.wsTransactionConfiguration.isAuditRequestPayload()) {
                svrFactory.getInInterceptors().add(new InPayloadExtractorInterceptor(StringPayloadHolder.PayloadType.SOAP_BODY));
            }
            AuditResponseInterceptor<AuditDatasetType> auditInterceptor = new AuditResponseInterceptor<AuditDatasetType>(this.auditStrategy, this.auditContext, false, this.correlator, true);
            svrFactory.getInInterceptors().add(auditInterceptor);
            svrFactory.getInFaultInterceptors().add(auditInterceptor);
        }
    }
}

