/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws.cxf.payload;

import com.ctc.wstx.io.UTF8Writer;
import com.ctc.wstx.sw.BaseStreamWriter;
import com.ctc.wstx.sw.BufferingXmlWriter;
import java.io.OutputStream;
import java.lang.reflect.Field;
import javax.xml.stream.XMLStreamWriter;
import org.apache.cxf.interceptor.StaxOutInterceptor;
import org.apache.cxf.io.CacheAndWriteOutputStream;
import org.apache.cxf.message.Message;
import org.apache.cxf.phase.AbstractPhaseInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.payload.WrappedOutputStream;

public class OutStreamSubstituteInterceptor
extends AbstractPhaseInterceptor<Message> {
    private static final Field MWRITER_FIELD;
    private static final Field MOUT_WRITER_FIELD;
    private static final Field MOUT_STREAM_FIELD;

    public OutStreamSubstituteInterceptor() {
        super("pre-stream");
        this.addAfter(StaxOutInterceptor.class.getName());
    }

    private static void checkClass(Object x, Class<?> expectedClass) {
        Class<?> realClass = x.getClass();
        if (!expectedClass.isAssignableFrom(realClass)) {
            throw new IllegalStateException("Expected " + expectedClass.getName() + ", got " + realClass.getName());
        }
    }

    public void handleMessage(Message message) {
        try {
            Object x = message.getContent(XMLStreamWriter.class);
            OutStreamSubstituteInterceptor.checkClass(x, BaseStreamWriter.class);
            x = MWRITER_FIELD.get(x);
            OutStreamSubstituteInterceptor.checkClass(x, BufferingXmlWriter.class);
            x = MOUT_WRITER_FIELD.get(x);
            OutStreamSubstituteInterceptor.checkClass(x, UTF8Writer.class);
            UTF8Writer writer = (UTF8Writer)x;
            x = MOUT_STREAM_FIELD.get(writer);
            OutStreamSubstituteInterceptor.checkClass(x, OutputStream.class);
            OutputStream os = (OutputStream)x;
            WrappedOutputStream wrapper = new WrappedOutputStream(os, (String)message.get((Object)Message.ENCODING));
            message.setContent(OutputStream.class, (Object)wrapper);
            MOUT_STREAM_FIELD.set(writer, wrapper);
        }
        catch (IllegalAccessException e) {
            throw new IllegalStateException(e);
        }
    }

    public static WrappedOutputStream getStreamWrapper(Message message) {
        OutputStream outputStream = (OutputStream)message.getContent(OutputStream.class);
        if (outputStream instanceof CacheAndWriteOutputStream) {
            outputStream = ((CacheAndWriteOutputStream)outputStream).getFlowThroughStream();
        }
        if (outputStream instanceof WrappedOutputStream) {
            return (WrappedOutputStream)outputStream;
        }
        throw new IllegalStateException("Message output stream is not of expected type");
    }

    static {
        try {
            MWRITER_FIELD = BaseStreamWriter.class.getDeclaredField("mWriter");
            MWRITER_FIELD.setAccessible(true);
            MOUT_WRITER_FIELD = BufferingXmlWriter.class.getDeclaredField("mOut");
            MOUT_WRITER_FIELD.setAccessible(true);
            MOUT_STREAM_FIELD = UTF8Writer.class.getDeclaredField("mOut");
            MOUT_STREAM_FIELD.setAccessible(true);
        }
        catch (NoSuchFieldException e) {
            throw new ExceptionInInitializerError(e);
        }
    }
}

