/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws;

import javax.net.ssl.HostnameVerifier;
import javax.net.ssl.SSLContext;
import org.apache.cxf.configuration.jsse.TLSClientParameters;
import org.apache.cxf.configuration.security.AuthorizationPolicy;
import org.apache.cxf.transport.http.HTTPConduit;
import org.openehealth.ipf.commons.ihe.core.SecurityInformation;

public class WsSecurityInformation
extends SecurityInformation {
    public WsSecurityInformation(boolean secure, SSLContext sslContext, HostnameVerifier hostnameVerifier, String username, String password) {
        super(secure, sslContext, hostnameVerifier, username, password);
    }

    protected void configureHttpConduit(HTTPConduit httpConduit) {
        if (this.isSecure()) {
            TLSClientParameters tlsClientParameters = httpConduit.getTlsClientParameters();
            if (tlsClientParameters == null) {
                tlsClientParameters = new TLSClientParameters();
                this.maybeUpdateSslContext(tlsClientParameters, true);
            } else {
                this.maybeUpdateSslContext(tlsClientParameters, false);
            }
            if (this.getHostnameVerifier() != null) {
                tlsClientParameters.setHostnameVerifier(this.getHostnameVerifier());
            }
            httpConduit.setTlsClientParameters(tlsClientParameters);
        }
        if (this.getUsername() != null) {
            AuthorizationPolicy authorizationPolicy = new AuthorizationPolicy();
            authorizationPolicy.setUserName(this.getUsername());
            authorizationPolicy.setPassword(this.getPassword());
            httpConduit.setAuthorization(authorizationPolicy);
        }
    }

    private void maybeUpdateSslContext(TLSClientParameters tlsClientParameters, boolean useDefaultSocketFactory) {
        if (this.getSslContext() == null) {
            if (useDefaultSocketFactory) {
                tlsClientParameters.setUseHttpsURLConnectionDefaultSslSocketFactory(true);
            }
        } else {
            tlsClientParameters.setSSLSocketFactory(this.getSslContext().getSocketFactory());
        }
    }
}

