/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.ihe.ws;

import java.util.List;
import java.util.Map;
import org.apache.cxf.endpoint.Client;
import org.apache.cxf.feature.AbstractFeature;
import org.apache.cxf.interceptor.InterceptorProvider;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.ihe.core.atna.AuditStrategy;
import org.openehealth.ipf.commons.ihe.ws.JaxWsClientFactory;
import org.openehealth.ipf.commons.ihe.ws.WsSecurityInformation;
import org.openehealth.ipf.commons.ihe.ws.WsTransactionConfiguration;
import org.openehealth.ipf.commons.ihe.ws.correlation.AsynchronyCorrelator;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.AuditOutRequestInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.AuditResponseInterceptor;
import org.openehealth.ipf.commons.ihe.ws.cxf.audit.WsAuditDataset;

public class JaxWsRequestClientFactory<AuditDatasetType extends WsAuditDataset>
extends JaxWsClientFactory<AuditDatasetType> {
    public JaxWsRequestClientFactory(WsTransactionConfiguration<AuditDatasetType> wsTransactionConfiguration, String serviceUrl, AuditStrategy<AuditDatasetType> auditStrategy, AuditContext auditContext, InterceptorProvider customInterceptors, List<AbstractFeature> features, Map<String, Object> properties, AsynchronyCorrelator<AuditDatasetType> correlator, WsSecurityInformation securityInformation) {
        super(wsTransactionConfiguration, serviceUrl, auditStrategy, auditContext, customInterceptors, features, properties, correlator, securityInformation);
    }

    @Override
    protected void configureInterceptors(Client client) {
        super.configureInterceptors(client);
        if (this.auditStrategy != null) {
            if (this.wsTransactionConfiguration.isAuditRequestPayload()) {
                JaxWsRequestClientFactory.installPayloadInterceptors(client);
            }
            client.getOutInterceptors().add(new AuditOutRequestInterceptor(this.auditStrategy, this.auditContext, this.correlator, this.getWsTransactionConfiguration()));
            AuditResponseInterceptor auditInterceptor = new AuditResponseInterceptor(this.auditStrategy, this.auditContext, false, this.correlator, false);
            client.getInInterceptors().add(auditInterceptor);
            client.getInFaultInterceptors().add(auditInterceptor);
        }
    }
}

