/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.unmarshal.dicom;

import java.io.IOException;
import java.io.Reader;
import java.io.StringReader;
import java.net.URL;
import java.time.Instant;
import java.time.LocalDateTime;
import java.time.ZoneOffset;
import java.time.format.DateTimeFormatter;
import java.time.format.DateTimeFormatterBuilder;
import java.time.temporal.TemporalAccessor;
import java.util.Base64;
import java.util.List;
import java.util.function.Function;
import org.jdom2.Document;
import org.jdom2.Element;
import org.jdom2.JDOMException;
import org.jdom2.input.SAXBuilder;
import org.jdom2.input.sax.XMLReaderJDOMFactory;
import org.jdom2.input.sax.XMLReaderXSDFactory;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.codes.AuditSourceType;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.NetworkAccessPointTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectDataLifeCycle;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCodeRole;
import org.openehealth.ipf.commons.audit.model.ActiveParticipantType;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.model.AuditSourceIdentificationType;
import org.openehealth.ipf.commons.audit.model.DicomObjectDescriptionType;
import org.openehealth.ipf.commons.audit.model.EventIdentificationType;
import org.openehealth.ipf.commons.audit.model.ParticipantObjectIdentificationType;
import org.openehealth.ipf.commons.audit.model.TypeValuePairType;
import org.openehealth.ipf.commons.audit.types.ActiveParticipantRoleId;
import org.openehealth.ipf.commons.audit.types.CodedValueType;
import org.openehealth.ipf.commons.audit.types.EventId;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.MediaType;
import org.openehealth.ipf.commons.audit.types.ParticipantObjectIdType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;
import org.openehealth.ipf.commons.audit.unmarshal.AuditParser;

public class DICOMAuditParser
implements AuditParser {
    private static XMLReaderJDOMFactory XSD_FACTORY;
    private static final DateTimeFormatter DATE_TIME_FORMATTER;

    @Override
    public AuditMessage parse(String s, boolean validate) {
        try {
            Document document = DICOMAuditParser.useSAXParser(new StringReader(s), validate);
            Element root = document.getRootElement();
            AuditMessage auditMessage = new AuditMessage();
            auditMessage.setEventIdentification(this.eventIdentificationType(root.getChild("EventIdentification")));
            this.mapInto(auditMessage.getActiveParticipants(), root, "ActiveParticipant", this::activeParticipantType);
            auditMessage.setAuditSourceIdentification(this.auditSourceIdentificationType(root.getChild("AuditSourceIdentification")));
            this.mapInto(auditMessage.getParticipantObjectIdentifications(), root, "ParticipantObjectIdentification", this::participantObjectIdentificationType);
            return auditMessage;
        }
        catch (AuditException e) {
            throw e;
        }
        catch (Exception e) {
            throw new AuditException(e);
        }
    }

    private EventIdentificationType eventIdentificationType(Element element) {
        EventIdentificationType ei = new EventIdentificationType(this.eventId(element.getChild("EventID")), this.dateTime(element.getAttributeValue("EventDateTime")), EventOutcomeIndicator.enumForCode(Integer.parseInt(element.getAttributeValue("EventOutcomeIndicator"))));
        this.mapInto(ei.getEventTypeCode(), element, "EventTypeCode", this::eventType);
        ei.setEventOutcomeDescription(element.getChildText("EventOutcomeDescription"));
        if (element.getAttribute("EventActionCode") != null) {
            ei.setEventActionCode(EventActionCode.enumForCode(element.getAttributeValue("EventActionCode")));
        }
        this.mapInto(ei.getPurposesOfUse(), element, "PurposeOfUse", this::purposeOfUse);
        return ei;
    }

    private ActiveParticipantType activeParticipantType(Element element) {
        ActiveParticipantType ap = new ActiveParticipantType(element.getAttributeValue("UserID"), Boolean.parseBoolean(element.getAttributeValue("UserIsRequestor")));
        ap.setAlternativeUserID(element.getAttributeValue("AlternativeUserID"));
        ap.setUserName(element.getAttributeValue("UserName"));
        ap.setNetworkAccessPointID(element.getAttributeValue("NetworkAccessPointID"));
        if (element.getAttribute("NetworkAccessPointTypeCode") != null) {
            ap.setNetworkAccessPointTypeCode(NetworkAccessPointTypeCode.enumForCode(Short.parseShort(element.getAttributeValue("NetworkAccessPointTypeCode"))));
        }
        this.mapInto(ap.getRoleIDCodes(), element, "RoleIDCode", this::activeParticipantRoleId);
        Element mediaIdentifier = element.getChild("MediaIdentifier");
        if (mediaIdentifier != null) {
            ap.setMediaIdentifier(mediaIdentifier.getText());
            if (element.getChild("MediaType") != null) {
                ap.setMediaType(this.mediaType(element.getChild("MediaType")));
            }
        }
        return ap;
    }

    private AuditSourceIdentificationType auditSourceIdentificationType(Element element) {
        AuditSourceIdentificationType asi = new AuditSourceIdentificationType(element.getAttributeValue("AuditSourceID"));
        asi.setAuditEnterpriseSiteID(element.getAttributeValue("AuditEnterpriseSiteID"));
        this.mapInto(asi.getAuditSourceType(), element, "AuditSourceTypeCode", e -> AuditSourceType.enumForCode(e.getAttributeValue("csd-code")));
        return asi;
    }

    private ParticipantObjectIdentificationType participantObjectIdentificationType(Element element) {
        ParticipantObjectIdentificationType poi = new ParticipantObjectIdentificationType(element.getAttributeValue("ParticipantObjectID"), this.participantObjectIdType(element.getChild("ParticipantObjectIDTypeCode")));
        if (element.getAttributeValue("ParticipantObjectTypeCode") != null) {
            poi.setParticipantObjectTypeCode(ParticipantObjectTypeCode.enumForCode(Short.parseShort(element.getAttributeValue("ParticipantObjectTypeCode"))));
        }
        if (element.getAttributeValue("ParticipantObjectTypeCodeRole") != null) {
            poi.setParticipantObjectTypeCodeRole(ParticipantObjectTypeCodeRole.enumForCode(Short.parseShort(element.getAttributeValue("ParticipantObjectTypeCodeRole"))));
        }
        if (element.getAttributeValue("ParticipantObjectDataLifeCycle") != null) {
            poi.setParticipantObjectDataLifeCycle(ParticipantObjectDataLifeCycle.enumForCode(Short.parseShort(element.getAttributeValue("ParticipantObjectDataLifeCycle"))));
        }
        poi.setParticipantObjectSensitivity(element.getAttributeValue("ParticipantObjectSensitivity"));
        poi.setParticipantObjectName(element.getChildText("ParticipantObjectName"));
        if (element.getChild("ParticipantObjectQuery") != null) {
            poi.setParticipantObjectQuery(Base64.getDecoder().decode(element.getChildTextTrim("ParticipantObjectQuery")));
        }
        this.mapInto(poi.getParticipantObjectDetails(), element, "ParticipantObjectDetail", this::valuePair);
        this.mapInto(poi.getParticipantObjectDescriptions(), element, "ParticipantObjectDescription", this::partipantObjectDescription);
        return poi;
    }

    private DicomObjectDescriptionType partipantObjectDescription(Element element) {
        DicomObjectDescriptionType dicom = new DicomObjectDescriptionType();
        this.mapInto(dicom.getMPPS(), element, "MPPS", e -> e.getAttributeValue("UID"));
        this.mapInto(dicom.getAccession(), element, "Accession", e -> e.getAttributeValue("Number"));
        this.mapInto(dicom.getSOPClasses(), element, "SOPClass", this::sopClass);
        Element studies = element.getChild("ParticipantObjectContainsStudy");
        this.mapInto(dicom.getStudyIDs(), studies, "StudyIDs", e -> e.getAttributeValue("UID"));
        if (element.getChild("Encrypted") != null) {
            dicom.setEncrypted(Boolean.parseBoolean(element.getChildText("Encrypted")));
        }
        if (element.getChild("Anonymized") != null) {
            dicom.setAnonymized(Boolean.parseBoolean(element.getChildText("Anonymized")));
        }
        return dicom;
    }

    private DicomObjectDescriptionType.SOPClass sopClass(Element element) {
        DicomObjectDescriptionType.SOPClass sopClass = new DicomObjectDescriptionType.SOPClass(Integer.parseInt(element.getAttributeValue("NumberOfInstances")));
        sopClass.setUid(element.getAttributeValue("UID"));
        this.mapInto(sopClass.getInstanceUids(), element, "Instance", e -> e.getAttributeValue("UID"));
        return sopClass;
    }

    private <T> void mapInto(List<T> container, Element element, String name, Function<Element, T> mapper) {
        if (element == null) {
            return;
        }
        container.addAll(element.getChildren(name).stream().map(mapper).toList());
    }

    private EventId eventId(Element codedValueElement) {
        return this.codedValue(codedValueElement, EventId::of);
    }

    private EventType eventType(Element codedValueElement) {
        return this.codedValue(codedValueElement, EventType::of);
    }

    private PurposeOfUse purposeOfUse(Element codedValueElement) {
        return this.codedValue(codedValueElement, PurposeOfUse::of);
    }

    private ActiveParticipantRoleId activeParticipantRoleId(Element codedValueElement) {
        return this.codedValue(codedValueElement, ActiveParticipantRoleId::of);
    }

    private MediaType mediaType(Element codedValueElement) {
        return this.codedValue(codedValueElement, MediaType::of);
    }

    private ParticipantObjectIdType participantObjectIdType(Element codedValueElement) {
        return this.codedValue(codedValueElement, ParticipantObjectIdType::of);
    }

    private TypeValuePairType valuePair(Element element) {
        return new TypeValuePairType(element.getAttributeValue("type"), Base64.getDecoder().decode(element.getAttributeValue("value")));
    }

    private <T> T codedValue(Element element, Function<CodedValueType, T> f) {
        return f.apply(CodedValueType.of(element.getAttributeValue("csd-code"), element.getAttributeValue("codeSystemName"), element.getAttributeValue("originalText"), element.getAttributeValue("displayName")));
    }

    private Instant dateTime(String s) {
        TemporalAccessor parsed = DATE_TIME_FORMATTER.parseBest(s, Instant::from, LocalDateTime::from);
        if (parsed instanceof Instant) {
            Instant instant = (Instant)parsed;
            return instant;
        }
        if (parsed instanceof LocalDateTime) {
            LocalDateTime localDateTime = (LocalDateTime)parsed;
            return localDateTime.atOffset(ZoneOffset.UTC).toInstant();
        }
        throw new AuditException("Could not parse " + s + " to Instant");
    }

    private static Document useSAXParser(Reader reader, boolean validate) throws JDOMException, IOException {
        SAXBuilder saxBuilder = validate ? new SAXBuilder(XSD_FACTORY) : new SAXBuilder();
        saxBuilder.setExpandEntities(false);
        return saxBuilder.build(reader);
    }

    static {
        DATE_TIME_FORMATTER = new DateTimeFormatterBuilder().append(DateTimeFormatter.ISO_LOCAL_DATE_TIME).optionalStart().appendOffsetId().toFormatter();
        try {
            XSD_FACTORY = new XMLReaderXSDFactory(new URL[]{DICOMAuditParser.class.getResource("/dicom2017c.xsd")});
        }
        catch (JDOMException jDOMException) {
            // empty catch block
        }
    }
}

