/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.server.support;

import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.openehealth.ipf.commons.audit.server.support.SyslogDetailsBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogParser {
    private static final Logger log = LoggerFactory.getLogger(SyslogParser.class);
    private static final Pattern syslogPattern = Pattern.compile("^<(\\d{1,3})>(\\d{1,3}) (\\S+) (\\S{1,255}) (\\S{1,48}) (\\S{1,128}) (\\S{1,32}) (\\[.*?]|-) (.*)$", 32);

    public static Map<String, Object> parse(String syslogMessage) {
        if (syslogMessage == null || syslogMessage.trim().isEmpty()) {
            throw new IllegalArgumentException("Syslog message cannot be null or empty");
        }
        log.debug("Parsing syslog message: {}", (Object)syslogMessage);
        try {
            Matcher matcher = syslogPattern.matcher(syslogMessage);
            if (!matcher.matches()) {
                throw new IllegalArgumentException("Syslog message does not match RFC 5424 format");
            }
            return new SyslogDetailsBuilder().addPriority(matcher.group(1)).addVersion(matcher.group(2)).addTimestamp(matcher.group(3)).addHostName(matcher.group(4)).addAppName(matcher.group(5)).addProcId(matcher.group(6)).addMsgId(matcher.group(7)).addStructuredData(matcher.group(8)).addMessage(matcher.group(9)).build();
        }
        catch (Exception e) {
            return new SyslogDetailsBuilder().failure(syslogMessage, e).build();
        }
    }
}

