/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.server.support;

import java.util.Map;
import java.util.function.Consumer;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.unmarshal.AuditParser;
import org.openehealth.ipf.commons.audit.unmarshal.dicom.DICOMAuditParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogEventDICOMPrinter {
    private static final Logger log = LoggerFactory.getLogger(SyslogEventDICOMPrinter.class);
    private static final AuditParser parser = new DICOMAuditParser();

    public static EventConsumer newEventConsumer(String channel) {
        return new EventConsumer(channel);
    }

    public static ErrorConsumer newErrorConsumer() {
        return new ErrorConsumer();
    }

    public static class EventConsumer
    implements Consumer<Map<String, Object>> {
        private final String channel;

        private EventConsumer(String channel) {
            this.channel = channel;
        }

        @Override
        public void accept(Map<String, Object> syslogMap) {
            log.info("Received event on {} from {}:{}", new Object[]{this.channel, syslogMap.get("syslog.remote.host"), syslogMap.get("syslog.remote.port")});
            log.info("Syslog Metadata: AppName: {}, HostName: {}, Timestamp: {}", new Object[]{syslogMap.get("syslog.header.appName"), syslogMap.get("syslog.header.hostName"), syslogMap.get("syslog.header.timestamp")});
            try {
                AuditMessage auditMessage = EventConsumer.parse(syslogMap);
                log.info("DICOM Payload is");
                log.info("{}", (Object)auditMessage);
            }
            catch (Exception e) {
                log.warn("Could not parse payload:", (Throwable)e);
                log.info("{}", syslogMap.get("syslog.message"));
            }
        }

        private static AuditMessage parse(Map<String, Object> syslogMap) {
            return parser.parse(syslogMap.get("syslog.message").toString(), false);
        }
    }

    public static class ErrorConsumer
    implements Consumer<Throwable> {
        private ErrorConsumer() {
        }

        @Override
        public void accept(Throwable throwable) {
            log.error("Error occurred while receiving a syslog event: ", throwable);
        }
    }
}

