/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.server.support;

import java.util.Collection;
import java.util.Map;
import java.util.concurrent.ConcurrentLinkedQueue;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.function.Consumer;
import java.util.function.Predicate;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.unmarshal.AuditParser;
import org.openehealth.ipf.commons.audit.unmarshal.dicom.DICOMAuditParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SyslogEventCollector
implements Consumer<Map<String, Object>> {
    private static final Logger log = LoggerFactory.getLogger(SyslogEventCollector.class);
    private static final AuditParser PARSER = new DICOMAuditParser();
    private final Collection<Map<String, Object>> syslogMaps = new ConcurrentLinkedQueue<Map<String, Object>>();

    public static SyslogEventCollector newInstance() {
        return new SyslogEventCollector();
    }

    public SyslogEventCollector withExpectation(Predicate<Map<String, Object>> predicate, int expectedElements) {
        return new WithExpectation(this, predicate, expectedElements);
    }

    public SyslogEventCollector withExpectation(int expectedElements) {
        return new WithExpectation(this, expectedElements);
    }

    public SyslogEventCollector withDelay(long delay) {
        return new WithDelay(this, delay);
    }

    private SyslogEventCollector() {
    }

    @Override
    public void accept(Map<String, Object> syslogMap) {
        log.debug("Collecting syslog event {}", syslogMap);
        this.syslogMaps.add(syslogMap);
    }

    public Collection<Map<String, Object>> getSyslogEvents() {
        return this.getSyslogEvents(syslogEvent -> true);
    }

    public Collection<Map<String, Object>> getSyslogEvents(Predicate<Map<String, Object>> predicate) {
        return this.syslogMaps.stream().filter(predicate).toList();
    }

    public void reset() {
        this.syslogMaps.clear();
    }

    public static AuditMessage parse(Map<String, Object> syslogMap, boolean validate) {
        return PARSER.parse(syslogMap.get("syslog.message").toString(), validate);
    }

    public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
        throw new UnsupportedOperationException("Only usable with subclasses");
    }

    private static class WithExpectation
    extends DelegatingEventCollector {
        private final Predicate<Map<String, Object>> predicate;
        private final int expectedElements;
        private CountDownLatch latch;

        private WithExpectation(SyslogEventCollector wrapped, int expectedElements) {
            this(wrapped, m -> true, expectedElements);
        }

        private WithExpectation(SyslogEventCollector wrapped, Predicate<Map<String, Object>> predicate, int expectedElements) {
            super(wrapped);
            this.predicate = predicate;
            this.expectedElements = expectedElements;
            this.latch = new CountDownLatch(expectedElements);
        }

        @Override
        public void accept(Map<String, Object> syslogMap) {
            if (this.predicate.test(syslogMap)) {
                super.accept(syslogMap);
                this.latch.countDown();
            }
        }

        @Override
        public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
            return this.latch.await(timeout, timeUnit);
        }

        @Override
        public void reset() {
            super.reset();
            this.latch = new CountDownLatch(this.expectedElements);
        }

        public long missingElements() {
            return this.latch.getCount();
        }
    }

    private static class WithDelay
    extends DelegatingEventCollector {
        private final long delay;

        public WithDelay(SyslogEventCollector wrapped, long delay) {
            super(wrapped);
            this.delay = delay;
        }

        @Override
        public void accept(Map<String, Object> syslogMap) {
            try {
                Thread.sleep(this.delay);
                super.accept(syslogMap);
            }
            catch (InterruptedException interruptedException) {
                // empty catch block
            }
        }
    }

    private static class DelegatingEventCollector
    extends SyslogEventCollector {
        private final SyslogEventCollector wrapped;

        public DelegatingEventCollector(SyslogEventCollector wrapped) {
            this.wrapped = wrapped;
        }

        @Override
        public Collection<Map<String, Object>> getSyslogEvents() {
            return this.wrapped.getSyslogEvents();
        }

        @Override
        public Collection<Map<String, Object>> getSyslogEvents(Predicate<Map<String, Object>> predicate) {
            return this.wrapped.getSyslogEvents(predicate);
        }

        @Override
        public void accept(Map<String, Object> syslogMap) {
            this.wrapped.accept(syslogMap);
        }

        @Override
        public void reset() {
            this.wrapped.reset();
        }

        @Override
        public boolean await(long timeout, TimeUnit timeUnit) throws InterruptedException {
            return this.wrapped.await(timeout, timeUnit);
        }
    }
}

