/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.server.support;

import java.time.Instant;
import java.util.ArrayList;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

class SyslogDetailsBuilder {
    private static final Logger log = LoggerFactory.getLogger(SyslogDetailsBuilder.class);
    private static final int MAX_PRIORITY = 191;
    private static final int MIN_PRIORITY = 0;
    private static final int SEVERITY_MASK = 7;
    private static final String NIL = "-";
    private static final Pattern paramPattern = Pattern.compile("([^\\s=]+)=\"([^\"]*)\"");
    private static final Pattern keyPattern = Pattern.compile("^[^\\s=\\[\\]]+$");
    private static final Pattern sdIdPattern = Pattern.compile("^[^\\[\\]=\\s]+$");
    private static final Pattern structuredDataPattern = Pattern.compile("\\[([^\\s=\\]]+)((?:\\s+[^\\s=]+=\"[^\"]*\")*)]");
    private final Map<String, Object> result = new LinkedHashMap<String, Object>();

    SyslogDetailsBuilder() {
    }

    public SyslogDetailsBuilder addPriority(String priorityString) {
        int priority = Integer.parseInt(priorityString);
        if (priority < 0 || priority > 191) {
            throw new IllegalArgumentException("Invalid priority value: " + priority);
        }
        this.result.put("syslog.header.pri", priority);
        this.result.put("syslog.header.severity", priority & 7);
        this.result.put("syslog.header.facility", priority >> 3);
        return this;
    }

    public SyslogDetailsBuilder addVersion(String versionString) {
        int version = Integer.parseInt(versionString);
        if (version <= 0) {
            throw new IllegalArgumentException("Invalid version value: " + version);
        }
        this.result.put("syslog.header.version", version);
        return this;
    }

    public SyslogDetailsBuilder addTimestamp(String timestampString) {
        try {
            Instant timestamp = Instant.parse(timestampString);
            this.result.put("syslog.header.timestamp", timestamp);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Invalid timestamp format: " + timestampString, e);
        }
        return this;
    }

    public SyslogDetailsBuilder addHostName(String hostName) {
        return this.addField(hostName, "syslog.header.hostName");
    }

    public SyslogDetailsBuilder addAppName(String appName) {
        return this.addField(appName, "syslog.header.appName");
    }

    public SyslogDetailsBuilder addProcId(String procId) {
        return this.addField(procId, "syslog.header.procId");
    }

    public SyslogDetailsBuilder addMsgId(String msgId) {
        return this.addField(msgId, "syslog.header.msgId");
    }

    public SyslogDetailsBuilder addStructuredData(String sd) {
        this.result.put("syslog.structuredData", SyslogDetailsBuilder.parseStructuredData(sd));
        return this;
    }

    public SyslogDetailsBuilder addMessage(String message) {
        this.result.put("syslog.message", message != null ? message : "");
        return this;
    }

    public SyslogDetailsBuilder failure(String syslogMessage, Exception e) {
        log.warn("Failed to match syslog format in message {}", (Object)syslogMessage, (Object)e);
        this.result.put("syslog.exceptions", e);
        this.result.put("syslog.raw.message", syslogMessage);
        return this;
    }

    private SyslogDetailsBuilder addField(String value, String header) {
        if (!NIL.equals(value)) {
            this.result.put(header, value);
        }
        return this;
    }

    private static List<Map<String, Object>> parseStructuredData(String sdRaw) {
        if (sdRaw == null || sdRaw.equals(NIL)) {
            return List.of();
        }
        ArrayList<Map<String, Object>> sdList = new ArrayList<Map<String, Object>>();
        Matcher matcher = structuredDataPattern.matcher(sdRaw);
        while (matcher.find()) {
            String sdId = matcher.group(1);
            LinkedHashMap<String, Object> sdEntry = new LinkedHashMap<String, Object>();
            sdEntry.put("syslog.structuredData.id", SyslogDetailsBuilder.validateSdId(sdId));
            sdEntry.put("syslog.structuredData.params", SyslogDetailsBuilder.getParams(matcher, sdId));
            sdList.add(sdEntry);
        }
        return sdList;
    }

    private static LinkedHashMap<String, String> getParams(Matcher matcher, String sdId) {
        String paramString = matcher.group(2);
        LinkedHashMap<String, String> params = new LinkedHashMap<String, String>();
        Matcher paramMatcher = paramPattern.matcher(paramString);
        while (paramMatcher.find()) {
            String key = paramMatcher.group(1);
            String value = paramMatcher.group(2);
            Matcher keyMatcher = keyPattern.matcher(key);
            if (!keyMatcher.matches()) {
                throw new IllegalArgumentException("Invalid parameter name: " + key);
            }
            if (params.containsKey(key)) {
                throw new IllegalArgumentException("Duplicate parameter key: " + key + " in SD-ID: " + sdId);
            }
            params.put(key, value);
        }
        return params;
    }

    private static String validateSdId(String sdId) {
        Matcher sdIdMatcher = sdIdPattern.matcher(sdId);
        if (!sdIdMatcher.matches()) {
            throw new IllegalArgumentException("Invalid SD-ID: " + sdId);
        }
        return sdId;
    }

    public Map<String, Object> build() {
        log.debug("Return syslog parser result: {}", this.result);
        return new LinkedHashMap<String, Object>(this.result);
    }
}

