/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.server;

import io.netty.channel.ChannelOption;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.logging.LogLevel;
import java.time.Duration;
import java.util.Map;
import java.util.function.Consumer;
import org.openehealth.ipf.commons.audit.server.Rfc5424Decoder;
import org.openehealth.ipf.commons.audit.server.SyslogServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.netty.Connection;
import reactor.netty.internal.util.Metrics;
import reactor.netty.udp.UdpServer;

public class UdpSyslogServer
extends SyslogServer<Connection> {
    private static final Logger log = LoggerFactory.getLogger(UdpSyslogServer.class);

    public UdpSyslogServer(Consumer<? super Map<String, Object>> consumer, Consumer<Throwable> errorConsumer) {
        super(consumer, errorConsumer);
    }

    public UdpSyslogServer doStart(String host, int port) {
        this.channel = UdpServer.create().option(ChannelOption.SO_REUSEADDR, (Object)true).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)Duration.ofSeconds(this.timeoutSeconds).toMillis())).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(65535)).host(host).port(port).wiretap(this.getClass().getName(), LogLevel.TRACE).metrics(Metrics.isMicrometerAvailable()).doOnBind(serverBootstrap -> log.info("UDP Syslog Server is about to be started")).doOnBound(disposableServer -> log.info("UDP Syslog Server bound on {}", (Object)disposableServer.channel().localAddress())).doOnUnbound(disposableServer -> log.info("UDP Syslog Server unbound from {}", (Object)disposableServer.channel().localAddress())).handle((udpInbound, udpOutbound) -> udpInbound.receiveObject().map(o -> (DatagramPacket)o).map(Rfc5424Decoder::decodeDatagram).flatMap(this::handleMap).doOnError(this.errorConsumer).then()).bindNow(Duration.ofSeconds(this.timeoutSeconds));
        return this;
    }
}

