/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.server;

import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelOption;
import io.netty.channel.FixedRecvByteBufAllocator;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.ssl.SslContext;
import java.time.Duration;
import java.util.Map;
import java.util.function.Consumer;
import org.openehealth.ipf.commons.audit.NettyUtils;
import org.openehealth.ipf.commons.audit.TlsParameters;
import org.openehealth.ipf.commons.audit.server.Rfc5424Decoder;
import org.openehealth.ipf.commons.audit.server.Rfc5425Decoder;
import org.openehealth.ipf.commons.audit.server.SyslogServer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import reactor.netty.DisposableChannel;
import reactor.netty.internal.util.Metrics;
import reactor.netty.tcp.TcpServer;

public class TlsSyslogServer
extends SyslogServer<DisposableChannel> {
    private static final Logger log = LoggerFactory.getLogger(TlsSyslogServer.class);
    protected final TlsParameters tlsParameters;

    public TlsSyslogServer(Consumer<? super Map<String, Object>> consumer, Consumer<Throwable> errorConsumer) {
        this(consumer, errorConsumer, TlsParameters.getDefault());
    }

    public TlsSyslogServer(Consumer<? super Map<String, Object>> consumer, Consumer<Throwable> errorConsumer, TlsParameters tlsParameters) {
        super(consumer, errorConsumer);
        this.tlsParameters = tlsParameters;
    }

    public TlsSyslogServer doStart(String host, int port) {
        SslContext sslContext = NettyUtils.initSslContext(this.tlsParameters, true);
        this.channel = ((TcpServer)((TcpServer)((TcpServer)TcpServer.create().host(host).port(port).option(ChannelOption.SO_REUSEADDR, (Object)true)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)Duration.ofSeconds(this.timeoutSeconds).toMillis()))).option(ChannelOption.RCVBUF_ALLOCATOR, (Object)new FixedRecvByteBufAllocator(65535))).wiretap(this.getClass().getName(), LogLevel.TRACE).metrics(Metrics.isMicrometerAvailable()).secure(spec -> spec.sslContext(sslContext)).doOnBind(serverBootstrap -> log.info("TLS Syslog Server is about to be started")).doOnBound(disposableServer -> log.info("TLS Syslog Server bound on {}", (Object)disposableServer.address())).doOnUnbound(disposableServer -> log.info("TLS Syslog Server unbound from {}", (Object)disposableServer.address())).doOnConnection(connection -> {
            log.debug("Received connection from {}", (Object)connection.channel().localAddress());
            connection.addHandlerLast((ChannelHandler)new Rfc5425Decoder()).addHandlerLast((ChannelHandler)new Rfc5424Decoder());
        }).handle((nettyInbound, nettyOutbound) -> nettyInbound.receiveObject().cast(Map.class).flatMap(this::handleMap).doOnError(this.errorConsumer).then()).bindNow(Duration.ofSeconds(this.timeoutSeconds));
        return this;
    }
}

