/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.server;

import java.io.Closeable;
import java.net.SocketAddress;
import java.time.Duration;
import java.util.Map;
import java.util.function.Consumer;
import lombok.Generated;
import reactor.core.publisher.Mono;
import reactor.core.scheduler.Schedulers;
import reactor.netty.DisposableChannel;

public abstract class SyslogServer<T extends DisposableChannel>
implements Closeable {
    static final int TIMEOUT = 10;
    protected T channel;
    protected final Consumer<? super Map<String, Object>> consumer;
    protected final Consumer<Throwable> errorConsumer;
    protected int timeoutSeconds = 10;

    public SyslogServer(Consumer<? super Map<String, Object>> consumer, Consumer<Throwable> errorConsumer) {
        this.consumer = consumer;
        this.errorConsumer = errorConsumer;
    }

    public SyslogServer<T> start(String host, int port) {
        if (this.channel != null) {
            throw new IllegalStateException("Syslog server is already running");
        }
        return this.doStart(host, port);
    }

    public SocketAddress address() {
        return this.channel.address();
    }

    protected abstract SyslogServer<T> doStart(String var1, int var2);

    public void stop() {
        if (this.channel != null) {
            this.channel.disposeNow(Duration.ofSeconds(this.timeoutSeconds));
        }
        this.channel = null;
    }

    protected Mono<Object> handleMap(Map<String, Object> map) {
        return Mono.fromRunnable(() -> this.consumer.accept(map)).subscribeOn(Schedulers.boundedElastic());
    }

    @Override
    public void close() {
        this.stop();
    }

    @Generated
    public void setTimeoutSeconds(int timeoutSeconds) {
        this.timeoutSeconds = timeoutSeconds;
    }
}

