/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.handler.codec.ByteToMessageDecoder;
import java.nio.charset.StandardCharsets;
import java.util.List;
import java.util.OptionalInt;

public class Rfc5425Decoder
extends ByteToMessageDecoder {
    private OptionalInt frameLength = OptionalInt.empty();

    protected void decode(ChannelHandlerContext ctx, ByteBuf in, List<Object> out) {
        if (this.frameLength.isEmpty()) {
            this.frameLength = this.getFrameLength(in);
            this.frameLength.ifPresentOrElse(i -> in.skipBytes(1), () -> ((ByteBuf)in).resetReaderIndex());
        }
        this.frameLength.ifPresent(length -> {
            if (in.readableBytes() >= length) {
                this.frameLength = OptionalInt.empty();
                out.add(in.readBytes(length));
            }
        });
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private OptionalInt getFrameLength(ByteBuf in) {
        int index = in.indexOf(0, in.readableBytes(), (byte)32);
        if (index < 0) {
            return OptionalInt.empty();
        }
        ByteBuf byteBuf = in.readBytes(index);
        try {
            CharSequence number = byteBuf.readCharSequence(byteBuf.readableBytes(), StandardCharsets.US_ASCII);
            OptionalInt optionalInt = OptionalInt.of(Integer.parseInt(number.toString()));
            return optionalInt;
        }
        catch (NumberFormatException ignored) {
            OptionalInt optionalInt = OptionalInt.empty();
            return optionalInt;
        }
        finally {
            byteBuf.release();
        }
    }
}

