/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.server;

import io.netty.buffer.ByteBuf;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.socket.DatagramPacket;
import io.netty.handler.codec.MessageToMessageDecoder;
import java.net.InetSocketAddress;
import java.net.SocketAddress;
import java.nio.charset.StandardCharsets;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.openehealth.ipf.commons.audit.server.support.SyslogParser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rfc5424Decoder
extends MessageToMessageDecoder<ByteBuf> {
    private static final Logger log = LoggerFactory.getLogger(Rfc5424Decoder.class);

    static Map<String, Object> decodeDatagram(DatagramPacket datagramPacket) {
        return Rfc5424Decoder.decode(datagramPacket.sender(), (ByteBuf)datagramPacket.content());
    }

    protected void decode(ChannelHandlerContext ctx, ByteBuf msg, List<Object> out) {
        out.add(Rfc5424Decoder.decode(ctx.channel().remoteAddress(), msg));
    }

    private static Map<String, Object> decode(SocketAddress socketAddress, ByteBuf msg) {
        if (log.isDebugEnabled()) {
            log.debug("Decoding message with {} bytes into RFC 5424 map.", (Object)msg.readableBytes());
        }
        Map<String, Object> map = Rfc5424Decoder.parseByteBuf(msg);
        if (socketAddress instanceof InetSocketAddress) {
            InetSocketAddress inetSocketAddress = (InetSocketAddress)socketAddress;
            HashMap<String, Object> enriched = new HashMap<String, Object>(map);
            enriched.put("syslog.remote.host", inetSocketAddress.getHostName());
            enriched.put("syslog.remote.port", inetSocketAddress.getPort());
            enriched.put("syslog.remote.ip", inetSocketAddress.getAddress().getHostAddress());
            return Collections.unmodifiableMap(enriched);
        }
        return map;
    }

    private static Map<String, Object> parseByteBuf(ByteBuf byteBuf) {
        String message = byteBuf.toString(StandardCharsets.UTF_8);
        return SyslogParser.parse(message.replace("\ufeff", ""));
    }
}

