/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.queue;

import jakarta.jms.Connection;
import jakarta.jms.ConnectionFactory;
import jakarta.jms.Destination;
import jakarta.jms.Message;
import jakarta.jms.MessageProducer;
import jakarta.jms.Queue;
import jakarta.jms.Session;
import jakarta.jms.TextMessage;
import java.util.Objects;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.queue.AbstractAuditMessageQueue;

public class JmsAuditMessageQueue
extends AbstractAuditMessageQueue {
    private final ConnectionFactory connectionFactory;
    private final String queueName;
    private final String userName;
    private final String password;

    public JmsAuditMessageQueue(ConnectionFactory connectionFactory, String queueName, String userName, String password) {
        this.connectionFactory = Objects.requireNonNull(connectionFactory, "ConnectionFactory must not be null");
        this.queueName = queueName != null ? queueName : "atna-audit";
        this.userName = userName;
        this.password = password;
    }

    @Override
    protected void handle(AuditContext auditContext, String auditMessage) {
        try {
            Connection connection;
            try (Connection connection2 = connection = this.connectionFactory.createConnection(this.userName, this.password);){
                connection.start();
                Session session = connection.createSession(false, 1);
                Queue queue = session.createQueue(this.queueName);
                MessageProducer producer = session.createProducer((Destination)queue);
                TextMessage message = session.createTextMessage(auditMessage);
                message.setStringProperty("X_IPF_ATNA_Timestamp", auditContext.getAuditMetadataProvider().getTimestamp());
                message.setStringProperty("X_IPF_ATNA_Hostname", auditContext.getAuditMetadataProvider().getHostname());
                message.setStringProperty("X_IPF_ATNA_ProcessID", auditContext.getAuditMetadataProvider().getProcessID());
                message.setStringProperty("X_IPF_ATNA_Application", auditContext.getSendingApplication());
                producer.send((Message)message);
            }
        }
        catch (Exception e) {
            auditContext.getAuditExceptionHandler().handleException(auditContext, e, auditMessage);
        }
    }
}

