/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.queue;

import jakarta.jms.JMSException;
import jakarta.jms.Message;
import jakarta.jms.MessageListener;
import jakarta.jms.TextMessage;
import java.util.Objects;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.AuditMetadataProvider;
import org.openehealth.ipf.commons.audit.DefaultAuditMetadataProvider;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class JmsAuditMessageListener
implements MessageListener {
    private static final Logger log = LoggerFactory.getLogger(JmsAuditMessageListener.class);
    private final AuditContext auditContext;

    public JmsAuditMessageListener(AuditContext auditContext) {
        this.auditContext = Objects.requireNonNull(auditContext, "AuditContext must not be null");
    }

    public void onMessage(Message message) {
        TextMessage textMessage = (TextMessage)message;
        try {
            String text = textMessage.getText();
            String hostname = message.getStringProperty("X_IPF_ATNA_Hostname");
            String processID = message.getStringProperty("X_IPF_ATNA_ProcessID");
            String application = message.getStringProperty("X_IPF_ATNA_Application");
            String timestamp = message.getStringProperty("X_IPF_ATNA_Timestamp");
            AuditMetadataProvider defaultProvider = this.auditContext.getAuditMetadataProvider();
            DefaultAuditMetadataProvider auditMetadataProvider = new DefaultAuditMetadataProvider(hostname != null ? hostname : defaultProvider.getHostname(), processID != null ? processID : defaultProvider.getProcessID(), application != null ? application : defaultProvider.getSendingApplication(), timestamp != null ? timestamp : defaultProvider.getTimestamp());
            this.auditContext.getAuditTransmissionProtocol().send(this.auditContext, auditMetadataProvider, text);
        }
        catch (JMSException jmsException1) {
            log.error("Could not obtain text from JMS message", (Throwable)jmsException1);
        }
        catch (Exception e) {
            log.warn("Could not send audit message, rolling back", (Throwable)e);
            throw new RuntimeException(e);
        }
    }
}

