/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.protocol;

import java.net.DatagramPacket;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.nio.charset.StandardCharsets;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.AuditMetadataProvider;
import org.openehealth.ipf.commons.audit.TlsParameters;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionChannel;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionProtocol;
import org.openehealth.ipf.commons.audit.protocol.RFC5424Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UDPSyslogSenderImpl
extends RFC5424Protocol
implements AuditTransmissionProtocol {
    private static final Logger log = LoggerFactory.getLogger(UDPSyslogSenderImpl.class);
    private static final int MAX_DATAGRAM_PACKET_SIZE = 65479;

    public UDPSyslogSenderImpl() {
    }

    public UDPSyslogSenderImpl(TlsParameters tlsParameters) {
    }

    @Override
    public String getTransportName() {
        return AuditTransmissionChannel.UDP.getProtocolName();
    }

    @Override
    public void send(AuditContext auditContext, AuditMetadataProvider auditMetadataProvider, String auditMessage) throws Exception {
        if (auditMessage != null) {
            try (DatagramSocket socket = new DatagramSocket();){
                byte[] msgBytes = this.getTransportPayload(auditMetadataProvider, auditMessage);
                InetAddress inetAddress = auditContext.getAuditRepositoryAddress();
                log.debug("Auditing {} bytes to {}:{} ({})", new Object[]{msgBytes.length, auditContext.getAuditRepositoryHostName(), auditContext.getAuditRepositoryPort(), inetAddress.getHostAddress()});
                DatagramPacket packet = new DatagramPacket(msgBytes, Math.min(65479, msgBytes.length), inetAddress, auditContext.getAuditRepositoryPort());
                socket.send(packet);
                if (log.isTraceEnabled()) {
                    log.trace(new String(msgBytes, StandardCharsets.UTF_8));
                }
            }
        }
    }

    @Override
    public void shutdown() {
    }
}

