/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.protocol;

import java.io.IOException;
import java.io.OutputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.net.SocketException;
import java.net.SocketTimeoutException;
import java.nio.charset.StandardCharsets;
import java.util.Objects;
import java.util.concurrent.atomic.AtomicReference;
import javax.net.SocketFactory;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.AuditMetadataProvider;
import org.openehealth.ipf.commons.audit.TlsParameters;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionChannel;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionProtocol;
import org.openehealth.ipf.commons.audit.protocol.RFC5425Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TLSSyslogSenderImpl
extends RFC5425Protocol
implements AuditTransmissionProtocol {
    private static final Logger log = LoggerFactory.getLogger(TLSSyslogSenderImpl.class);
    private static final int MIN_SO_TIMEOUT = 1;
    private static final Boolean DEFAULT_SOCKET_KEEPALIVE = Boolean.TRUE;
    private final AtomicReference<Socket> socket = new AtomicReference();
    private final SocketFactory socketFactory;
    private final SocketTestPolicy socketTestPolicy;

    public TLSSyslogSenderImpl() {
        this(SocketTestPolicy.TEST_BEFORE_WRITE);
    }

    public TLSSyslogSenderImpl(SocketTestPolicy socketTestPolicy) {
        this.socketFactory = SSLSocketFactory.getDefault();
        this.socketTestPolicy = socketTestPolicy;
    }

    public TLSSyslogSenderImpl(TlsParameters tlsParameters) {
        this(tlsParameters.getSSLSocketFactory(false), SocketTestPolicy.TEST_BEFORE_WRITE);
    }

    public TLSSyslogSenderImpl(SSLSocketFactory socketFactory, SocketTestPolicy socketTestPolicy) {
        this.socketFactory = socketFactory;
        this.socketTestPolicy = socketTestPolicy;
    }

    public TLSSyslogSenderImpl(TlsParameters tlsParameters, SocketTestPolicy socketTestPolicy) {
        this(tlsParameters.getSSLSocketFactory(false), socketTestPolicy);
    }

    @Override
    public String getTransportName() {
        return AuditTransmissionChannel.TLS.getProtocolName();
    }

    private Socket getSocket(AuditContext auditContext) {
        if (this.socket.get() == null) {
            this.socket.compareAndSet(null, this.getTLSSocket(auditContext));
        }
        return this.socket.get();
    }

    @Override
    public void send(AuditContext auditContext, AuditMetadataProvider auditMetadataProvider, String auditMessage) throws Exception {
        if (auditMessage != null) {
            byte[] msgBytes = this.getTransportPayload(auditMetadataProvider, auditMessage);
            log.debug("Auditing {} bytes to {}:{}", new Object[]{msgBytes.length, auditContext.getAuditRepositoryHostName(), auditContext.getAuditRepositoryPort()});
            try {
                this.doSend(auditContext, msgBytes);
                if (log.isTraceEnabled()) {
                    log.trace(new String(msgBytes, StandardCharsets.UTF_8));
                }
            }
            catch (SocketException | SocketTimeoutException e) {
                try {
                    log.info("Failed to use existing TLS socket. Will create a new connection and retry.");
                    this.closeSocket(this.socket.get());
                    this.socket.set(null);
                    this.doSend(auditContext, msgBytes);
                }
                catch (Exception exception) {
                    log.error("Failed to audit using new TLS socket, giving up - this audit message will be lost.");
                    this.closeSocket(this.socket.get());
                    this.socket.set(null);
                    throw exception;
                }
            }
        }
    }

    @Override
    public void shutdown() {
        if (this.socket.get() != null) {
            this.closeSocket(this.socket.get());
        }
    }

    private synchronized void doSend(AuditContext auditContext, byte[] msgBytes) throws IOException {
        Socket socket = this.getSocket(auditContext);
        if (this.socketTestPolicy.isBeforeWrite()) {
            log.trace("Testing whether socket connection is alive and well before attempting to write");
            if (!this.isSocketConnectionAlive(socket)) {
                this.closeSocket(socket);
                throw new FastSocketException("Read-test before write operation determined that the socket connection is dead");
            }
            log.debug("Socket connection is confirmed to be alive.");
        }
        log.trace("Now writing out ATNA record");
        OutputStream out = socket.getOutputStream();
        out.write(msgBytes);
        out.flush();
        log.trace("ATNA record has been written ({} bytes)", (Object)msgBytes.length);
        if (this.socketTestPolicy.isAfterWrite()) {
            log.trace("Testing whether socket connection is alive and well after write to confirm the write operation");
            if (!this.isSocketConnectionAlive(socket)) {
                this.closeSocket(socket);
                throw new FastSocketException("Read-test after write operation determined that the socket connection is dead");
            }
            log.debug("Socket connection is confirmed alive. Assuming write operation has succeeded");
        }
    }

    private Socket getTLSSocket(AuditContext auditContext) {
        SSLSocket socket;
        InetAddress auditRepositoryAddress = auditContext.getAuditRepositoryAddress();
        try {
            socket = (SSLSocket)this.socketFactory.createSocket(auditRepositoryAddress, auditContext.getAuditRepositoryPort());
            this.setSocketOptions(socket);
            if (this.socketTestPolicy != SocketTestPolicy.DONT_TEST_POLICY) {
                socket.startHandshake();
                socket.setSoTimeout(1);
            }
        }
        catch (IOException e) {
            throw new AuditException(String.format("Could not establish TLS connection to %s:%d (%s)", auditContext.getAuditRepositoryHostName(), auditContext.getAuditRepositoryPort(), auditRepositoryAddress.getHostAddress()), e);
        }
        return socket;
    }

    protected void setSocketOptions(Socket socket) throws SocketException {
        Objects.requireNonNull(socket);
        socket.setKeepAlive(DEFAULT_SOCKET_KEEPALIVE);
    }

    private boolean isSocketConnectionAlive(Socket socket) {
        boolean isAlive;
        block6: {
            try {
                if (socket.getSoTimeout() > 0) {
                    int nextByte = socket.getInputStream().read();
                    if (nextByte > -1) {
                        log.warn("Socket test was able to read a byte from the socket other than the 'stream closed' value of -1. This should never happen since SYSLOG is a simplex (write only) protocol! Byte value read from stream: {}", (Object)nextByte);
                        isAlive = true;
                    } else {
                        log.debug("Socket test read '-1' -> connection closed by server.");
                        isAlive = false;
                    }
                    break block6;
                }
                throw new IllegalStateException("Test requires an SO_TIMEOUT greater than zero set on the socket.");
            }
            catch (SocketTimeoutException e) {
                log.debug("Socket read timed out; assuming the connection is still alive.");
                isAlive = true;
            }
            catch (IOException e) {
                log.warn("Socket read failed for non-timeout reason; assuming the connection is dead.");
                isAlive = false;
            }
        }
        return isAlive;
    }

    private void closeSocket(Socket socket) {
        if (socket != null && !socket.isClosed()) {
            try {
                socket.close();
            }
            catch (IOException e) {
                log.debug("Failed to close pre-existing socket. As we are either shutting down or are in the process of replacing the socket this is not really a worry... Message: {}", (Object)e.getMessage());
            }
        }
    }

    public static enum SocketTestPolicy {
        DONT_TEST_POLICY(false, false),
        TEST_BEFORE_WRITE(true, false),
        TEST_AFTER_WRITE(false, true),
        TEST_BEFORE_AND_AFTER_WRITE(true, true);

        private final boolean beforeWrite;
        private final boolean afterWrite;

        private SocketTestPolicy(boolean beforeWrite, boolean afterWrite) {
            this.beforeWrite = beforeWrite;
            this.afterWrite = afterWrite;
        }

        public boolean isBeforeWrite() {
            return this.beforeWrite;
        }

        public boolean isAfterWrite() {
            return this.afterWrite;
        }
    }

    private static class FastSocketException
    extends SocketException {
        public FastSocketException(String msg) {
            super(msg);
        }

        @Override
        public Throwable fillInStackTrace() {
            return null;
        }
    }
}

