/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.protocol;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.Consumer;
import lombok.Generated;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.AuditMetadataProvider;
import org.openehealth.ipf.commons.audit.TlsParameters;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionProtocol;

public class RecordingAuditMessageTransmission
implements AuditTransmissionProtocol {
    private Consumer<String> consumer;
    private final List<String> messages;

    public RecordingAuditMessageTransmission() {
        this.consumer = auditMessage -> {};
        this.messages = new ArrayList<String>();
    }

    public RecordingAuditMessageTransmission(TlsParameters dummy) {
        this.consumer = auditMessage -> {};
        this.messages = new ArrayList<String>();
    }

    @Override
    public void send(AuditContext auditContext, AuditMetadataProvider auditMetadataProvider, String auditMessage) {
        if (auditMessage != null) {
            this.consumer.accept(auditMessage);
            this.messages.add(auditMessage);
        }
    }

    @Override
    public void shutdown() {
    }

    @Override
    public String getTransportName() {
        return "RECORDER";
    }

    public List<String> getMessages() {
        return Collections.unmodifiableList(this.messages);
    }

    public Optional<String> getFirstMessage() {
        return this.getMessages().stream().findFirst();
    }

    public void clear() {
        this.messages.clear();
    }

    @Generated
    public void setConsumer(Consumer<String> consumer) {
        this.consumer = consumer;
    }
}

