/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.protocol;

import java.nio.charset.StandardCharsets;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.AuditMetadataProvider;
import org.openehealth.ipf.commons.audit.TlsParameters;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionProtocol;
import org.openehealth.ipf.commons.audit.protocol.RFC5425Protocol;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class NioTLSSyslogSenderImpl<H, D extends Destination<H>>
extends RFC5425Protocol
implements AuditTransmissionProtocol {
    private static final Logger log = LoggerFactory.getLogger(NioTLSSyslogSenderImpl.class);
    private boolean loggingEnabled = false;
    private final TlsParameters tlsParameters;
    private final Map<String, D> destinations = new ConcurrentHashMap<String, D>();

    public NioTLSSyslogSenderImpl(TlsParameters tlsParameters) {
        this.tlsParameters = tlsParameters;
    }

    public void setLoggingEnabled(boolean loggingEnabled) {
        this.loggingEnabled = loggingEnabled;
    }

    protected D customizeDestination(D destination) {
        return destination;
    }

    @Override
    public void send(AuditContext auditContext, AuditMetadataProvider auditMetadataProvider, String auditMessage) {
        if (auditMessage != null) {
            D destination = this.getDestination(auditContext.getAuditRepositoryHostName(), auditContext.getAuditRepositoryPort());
            byte[] payload = this.getTransportPayload(auditMetadataProvider, auditMessage);
            if (log.isDebugEnabled()) {
                log.debug("Auditing {} bytes to {}:{}", new Object[]{payload.length, auditContext.getAuditRepositoryHostName(), auditContext.getAuditRepositoryPort()});
            }
            destination.write(payload);
            if (log.isTraceEnabled()) {
                log.trace(new String(payload, StandardCharsets.UTF_8));
            }
        }
    }

    private D getDestination(String host, int port) {
        return (D)this.destinations.computeIfAbsent(host + port, s -> this.customizeDestination(this.makeDestination(this.tlsParameters, host, port, this.loggingEnabled)));
    }

    protected abstract D makeDestination(TlsParameters var1, String var2, int var3, boolean var4);

    @Override
    public void shutdown() {
        this.destinations.values().forEach(Destination::shutdown);
    }

    public static interface Destination<H> {
        public void write(byte[] var1);

        public void shutdown();

        public H getHandle();
    }
}

