/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.protocol;

import java.util.Arrays;
import java.util.ServiceLoader;
import java.util.stream.Collectors;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.TlsParameters;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionProtocol;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionProtocolProvider;
import org.openehealth.ipf.commons.audit.protocol.providers.NettyTLSSyslogSenderProvider;
import org.openehealth.ipf.commons.audit.protocol.providers.ReactorNettyTLSSyslogSenderProvider;
import org.openehealth.ipf.commons.audit.protocol.providers.RecordingAuditMessageTransmissionProvider;
import org.openehealth.ipf.commons.audit.protocol.providers.TLSSyslogSenderProvider;
import org.openehealth.ipf.commons.audit.protocol.providers.UDPSyslogSenderProvider;

public enum AuditTransmissionChannel {
    UDP("UDP", UDPSyslogSenderProvider.class.getName()),
    NIO_UDP("NIO-UDP", UDPSyslogSenderProvider.class.getName()),
    VERTX_UDP("VERTX-UDP", UDPSyslogSenderProvider.class.getName()),
    TLS("TLS", TLSSyslogSenderProvider.class.getName()),
    NIO_TLS("NIO-TLS", NettyTLSSyslogSenderProvider.class.getName()),
    NETTY_TLS("NETTY-TLS", NettyTLSSyslogSenderProvider.class.getName()),
    REACTOR_NETTY_TLS("REACTOR-NETTY-TLS", ReactorNettyTLSSyslogSenderProvider.class.getName()),
    FHIR_REST_TLS("FHIR-REST-TLS", "org.openehealth.ipf.commons.ihe.fhir.audit.protocol.FhirRestTLSAuditRecordApacheSenderProvider"),
    FHIR_REST_APACHE5_TLS("FHIR-REST-APACHE5-TLS", "org.openehealth.ipf.commons.ihe.fhir.audit.protocol.FhirRestTLSAuditRecordApache5SenderProvider"),
    FHIR_REST_METHANOL_TLS("FHIR-REST-METHANOL-TLS", "org.openehealth.ipf.commons.ihe.fhir.audit.protocol.FhirRestTLSAuditRecordMethanolSenderProvider"),
    RECORDING("RECORDING", RecordingAuditMessageTransmissionProvider.class.getName());

    private final String protocolName;
    private final String protocolClass;

    private AuditTransmissionChannel(String protocolName, String protocolClass) {
        this.protocolName = protocolName;
        this.protocolClass = protocolClass;
    }

    public String getProtocolName() {
        return this.protocolName;
    }

    public AuditTransmissionProtocol makeInstance(TlsParameters tlsParameters) {
        ServiceLoader<AuditTransmissionProtocolProvider> loader = ServiceLoader.load(AuditTransmissionProtocolProvider.class);
        for (AuditTransmissionProtocolProvider provider : loader) {
            if (!this.protocolClass.equals(provider.getClass().getName())) continue;
            return provider.createAuditTransmissionProtocol(tlsParameters);
        }
        throw new AuditException("Could not instantiate AuditTransmissionProtocolProvider for name " + this.protocolName);
    }

    public static AuditTransmissionChannel fromProtocolName(String protocolName) {
        for (AuditTransmissionChannel channel : AuditTransmissionChannel.values()) {
            if (!channel.protocolName.equalsIgnoreCase(protocolName)) continue;
            return channel;
        }
        throw new IllegalArgumentException("Unknown audit protocol name: " + protocolName + ". Choose one of: " + Arrays.stream(AuditTransmissionChannel.values()).map(AuditTransmissionChannel::getProtocolName).collect(Collectors.joining(",")));
    }
}

