/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import lombok.Generated;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.marshal.dicom.Current;
import org.openehealth.ipf.commons.audit.model.ActiveParticipantType;
import org.openehealth.ipf.commons.audit.model.AuditSourceIdentificationType;
import org.openehealth.ipf.commons.audit.model.EventIdentificationType;
import org.openehealth.ipf.commons.audit.model.ParticipantObjectIdentificationType;
import org.openehealth.ipf.commons.audit.model.Validateable;

public class AuditMessage
implements Serializable,
Validateable {
    private EventIdentificationType eventIdentification;
    private List<ActiveParticipantType> activeParticipants;
    private AuditSourceIdentificationType auditSourceIdentification;
    private List<ParticipantObjectIdentificationType> participantObjectIdentifications;

    public List<ActiveParticipantType> getActiveParticipants() {
        if (this.activeParticipants == null) {
            this.activeParticipants = new ArrayList<ActiveParticipantType>();
        }
        return this.activeParticipants;
    }

    public List<ActiveParticipantType> findActiveParticipants(Predicate<ActiveParticipantType> selector) {
        return this.getActiveParticipants().stream().filter(selector).collect(Collectors.toList());
    }

    public List<ParticipantObjectIdentificationType> getParticipantObjectIdentifications() {
        if (this.participantObjectIdentifications == null) {
            this.participantObjectIdentifications = new ArrayList<ParticipantObjectIdentificationType>();
        }
        return this.participantObjectIdentifications;
    }

    public List<ParticipantObjectIdentificationType> findParticipantObjectIdentifications(Predicate<ParticipantObjectIdentificationType> selector) {
        return this.getParticipantObjectIdentifications().stream().filter(selector).collect(Collectors.toList());
    }

    @Override
    public void validate() {
        if (this.eventIdentification == null) {
            throw new AuditException("The event must be identified");
        }
        if (this.auditSourceIdentification == null) {
            throw new AuditException("The event must be have an audit source");
        }
        if (this.activeParticipants == null || this.activeParticipants.isEmpty()) {
            throw new AuditException("The event must have one or more active participants");
        }
        this.eventIdentification.validate();
        this.auditSourceIdentification.validate();
        this.activeParticipants.forEach(ActiveParticipantType::validate);
        if (this.participantObjectIdentifications != null) {
            this.participantObjectIdentifications.forEach(ParticipantObjectIdentificationType::validate);
        }
    }

    public String toString() {
        return Current.toString(this, true);
    }

    @Generated
    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof AuditMessage)) {
            return false;
        }
        AuditMessage other = (AuditMessage)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EventIdentificationType this$eventIdentification = this.getEventIdentification();
        EventIdentificationType other$eventIdentification = other.getEventIdentification();
        if (this$eventIdentification == null ? other$eventIdentification != null : !((Object)this$eventIdentification).equals(other$eventIdentification)) {
            return false;
        }
        List<ActiveParticipantType> this$activeParticipants = this.getActiveParticipants();
        List<ActiveParticipantType> other$activeParticipants = other.getActiveParticipants();
        if (this$activeParticipants == null ? other$activeParticipants != null : !((Object)this$activeParticipants).equals(other$activeParticipants)) {
            return false;
        }
        AuditSourceIdentificationType this$auditSourceIdentification = this.getAuditSourceIdentification();
        AuditSourceIdentificationType other$auditSourceIdentification = other.getAuditSourceIdentification();
        if (this$auditSourceIdentification == null ? other$auditSourceIdentification != null : !((Object)this$auditSourceIdentification).equals(other$auditSourceIdentification)) {
            return false;
        }
        List<ParticipantObjectIdentificationType> this$participantObjectIdentifications = this.getParticipantObjectIdentifications();
        List<ParticipantObjectIdentificationType> other$participantObjectIdentifications = other.getParticipantObjectIdentifications();
        return !(this$participantObjectIdentifications == null ? other$participantObjectIdentifications != null : !((Object)this$participantObjectIdentifications).equals(other$participantObjectIdentifications));
    }

    @Generated
    protected boolean canEqual(Object other) {
        return other instanceof AuditMessage;
    }

    @Generated
    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventIdentificationType $eventIdentification = this.getEventIdentification();
        result = result * 59 + ($eventIdentification == null ? 43 : ((Object)$eventIdentification).hashCode());
        List<ActiveParticipantType> $activeParticipants = this.getActiveParticipants();
        result = result * 59 + ($activeParticipants == null ? 43 : ((Object)$activeParticipants).hashCode());
        AuditSourceIdentificationType $auditSourceIdentification = this.getAuditSourceIdentification();
        result = result * 59 + ($auditSourceIdentification == null ? 43 : ((Object)$auditSourceIdentification).hashCode());
        List<ParticipantObjectIdentificationType> $participantObjectIdentifications = this.getParticipantObjectIdentifications();
        result = result * 59 + ($participantObjectIdentifications == null ? 43 : ((Object)$participantObjectIdentifications).hashCode());
        return result;
    }

    @Generated
    public EventIdentificationType getEventIdentification() {
        return this.eventIdentification;
    }

    @Generated
    public void setEventIdentification(EventIdentificationType eventIdentification) {
        this.eventIdentification = eventIdentification;
    }

    @Generated
    public AuditSourceIdentificationType getAuditSourceIdentification() {
        return this.auditSourceIdentification;
    }

    @Generated
    public void setAuditSourceIdentification(AuditSourceIdentificationType auditSourceIdentification) {
        this.auditSourceIdentification = auditSourceIdentification;
    }
}

