/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.event;

import java.util.Collections;
import java.util.List;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventIdCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectIdTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCodeRole;
import org.openehealth.ipf.commons.audit.event.BaseAuditMessageBuilder;
import org.openehealth.ipf.commons.audit.types.ActiveParticipantRoleId;
import org.openehealth.ipf.commons.audit.types.EventId;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;

public class AuditLogUsedBuilder
extends BaseAuditMessageBuilder<AuditLogUsedBuilder> {
    public AuditLogUsedBuilder(EventOutcomeIndicator outcome) {
        this(outcome, null);
    }

    public AuditLogUsedBuilder(EventOutcomeIndicator outcome, String eventOutcomeDescription) {
        this.setEventIdentification(outcome, eventOutcomeDescription, EventActionCode.Read, (EventId)EventIdCode.AuditLogUsed, null, new PurposeOfUse[0]);
    }

    public AuditLogUsedBuilder addAccessingParticipant(String userId, String altUserId, String userName, boolean userIsRequestor, List<ActiveParticipantRoleId> roleIds, String networkId) {
        return (AuditLogUsedBuilder)this.addActiveParticipant(userId, altUserId, userName, userIsRequestor, roleIds, networkId);
    }

    public AuditLogUsedBuilder addAuditLogIdentity(String auditLogUri) {
        return (AuditLogUsedBuilder)this.addParticipantObjectIdentification(ParticipantObjectIdTypeCode.URI, "Security Audit Log", null, Collections.emptyList(), auditLogUri, ParticipantObjectTypeCode.System, ParticipantObjectTypeCodeRole.SecurityResource, null, null);
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getMessage().getActiveParticipants().isEmpty() || this.getMessage().getActiveParticipants().size() > 2) {
            throw new AuditException("Must have one or two participants that started the Application");
        }
    }
}

