/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit;

import java.time.Instant;
import java.time.temporal.ChronoUnit;
import java.time.temporal.TemporalUnit;
import java.util.Objects;
import org.openehealth.ipf.commons.audit.AuditMetadataProvider;
import org.openehealth.ipf.commons.audit.utils.AuditUtils;

public class DefaultAuditMetadataProvider
implements AuditMetadataProvider {
    private String hostName;
    private String processID;
    private String sendingApplication;
    private String timestamp;
    private TemporalUnit precision = ChronoUnit.MILLIS;

    public DefaultAuditMetadataProvider() {
        this(AuditUtils.getLocalHostName(), AuditUtils.getProcessId(), "IPF", null);
    }

    public DefaultAuditMetadataProvider(String hostName, String processID, String sendingApplication, String timestamp) {
        this.hostName = hostName;
        this.processID = processID;
        this.sendingApplication = Objects.requireNonNull(sendingApplication);
        this.timestamp = timestamp;
    }

    @Override
    public void setSendingApplication(String sendingApplication) {
        this.sendingApplication = Objects.requireNonNull(sendingApplication);
    }

    public void setHostName(String hostName) {
        this.hostName = hostName;
    }

    public void setProcessID(String processID) {
        this.processID = processID;
    }

    public void setPrecision(TemporalUnit precision) {
        this.precision = precision;
    }

    public void setTimestamp(String timestamp) {
        this.timestamp = timestamp;
    }

    @Override
    public String getTimestamp() {
        return this.timestamp != null ? this.timestamp : Instant.now().truncatedTo(this.precision).toString();
    }

    @Override
    public String getHostname() {
        return this.hostName;
    }

    @Override
    public String getSendingApplication() {
        return this.sendingApplication;
    }

    @Override
    public String getProcessID() {
        return this.processID;
    }
}

