/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit;

import io.micrometer.context.ContextRegistry;
import io.micrometer.context.ThreadLocalAccessor;
import io.micrometer.context.integration.Slf4jThreadLocalAccessor;
import java.net.InetAddress;
import java.net.UnknownHostException;
import lombok.Generated;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.AuditMessagePostProcessor;
import org.openehealth.ipf.commons.audit.AuditMetadataProvider;
import org.openehealth.ipf.commons.audit.FhirAuditDatasetEnricher;
import org.openehealth.ipf.commons.audit.TlsParameters;
import org.openehealth.ipf.commons.audit.WsAuditDatasetEnricher;
import org.openehealth.ipf.commons.audit.codes.AuditSourceType;
import org.openehealth.ipf.commons.audit.handler.AuditExceptionHandler;
import org.openehealth.ipf.commons.audit.handler.LoggingAuditExceptionHandler;
import org.openehealth.ipf.commons.audit.marshal.SerializationStrategy;
import org.openehealth.ipf.commons.audit.marshal.dicom.Current;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionChannel;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionProtocol;
import org.openehealth.ipf.commons.audit.protocol.UDPSyslogSenderImpl;
import org.openehealth.ipf.commons.audit.queue.AuditMessageQueue;
import org.openehealth.ipf.commons.audit.queue.SynchronousAuditMessageQueue;
import org.openehealth.ipf.commons.audit.types.AuditSource;

public class DefaultAuditContext
implements AuditContext {
    static final AuditContext NO_AUDIT = new DefaultAuditContext();
    private String auditRepositoryHostName = "localhost";
    private int auditRepositoryPort = 514;
    private boolean auditEnabled = false;
    private AuditTransmissionProtocol auditTransmissionProtocol = new UDPSyslogSenderImpl();
    private AuditMessageQueue auditMessageQueue = new SynchronousAuditMessageQueue();
    private String auditSourceId = "IPF";
    private String auditEnterpriseSiteId = "IPF";
    private AuditSource auditSource = AuditSourceType.Other;
    private SerializationStrategy serializationStrategy = new Current();
    private AuditMessagePostProcessor auditMessagePostProcessor = AuditMessagePostProcessor.noOp();
    private AuditExceptionHandler auditExceptionHandler = new LoggingAuditExceptionHandler();
    private AuditMetadataProvider auditMetadataProvider = AuditMetadataProvider.getDefault();
    private TlsParameters tlsParameters = TlsParameters.getDefault();
    private boolean includeParticipantsFromResponse = false;
    private String auditValueIfMissing = "UNKNOWN";
    private WsAuditDatasetEnricher wsAuditDatasetEnricher;
    private FhirAuditDatasetEnricher fhirAuditDatasetEnricher;
    private final ContextRegistry contextRegistry = new ContextRegistry().registerThreadLocalAccessor((ThreadLocalAccessor)new Slf4jThreadLocalAccessor(new String[0]));

    public String getAuditRepositoryTransport() {
        return this.auditTransmissionProtocol.getTransportName();
    }

    public void setAuditRepositoryHost(String host) {
        this.setAuditRepositoryHostName(host);
    }

    public void setAuditRepositoryTransport(String transport) {
        this.setAuditTransmissionProtocol(AuditTransmissionChannel.fromProtocolName(transport).makeInstance(this.tlsParameters));
    }

    @Override
    public String getSendingApplication() {
        return this.getAuditMetadataProvider().getSendingApplication();
    }

    @Override
    public InetAddress getAuditRepositoryAddress() {
        try {
            return InetAddress.getByName(this.auditRepositoryHostName);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public <T extends WsAuditDatasetEnricher> T getWsAuditDatasetEnricher() {
        return (T)this.wsAuditDatasetEnricher;
    }

    @Override
    public <T extends FhirAuditDatasetEnricher> T getFhirAuditDatasetEnricher() {
        return (T)this.fhirAuditDatasetEnricher;
    }

    @Override
    @Generated
    public String getAuditRepositoryHostName() {
        return this.auditRepositoryHostName;
    }

    @Generated
    public void setAuditRepositoryHostName(String auditRepositoryHostName) {
        this.auditRepositoryHostName = auditRepositoryHostName;
    }

    @Override
    @Generated
    public int getAuditRepositoryPort() {
        return this.auditRepositoryPort;
    }

    @Generated
    public void setAuditRepositoryPort(int auditRepositoryPort) {
        this.auditRepositoryPort = auditRepositoryPort;
    }

    @Override
    @Generated
    public boolean isAuditEnabled() {
        return this.auditEnabled;
    }

    @Generated
    public void setAuditEnabled(boolean auditEnabled) {
        this.auditEnabled = auditEnabled;
    }

    @Override
    @Generated
    public AuditTransmissionProtocol getAuditTransmissionProtocol() {
        return this.auditTransmissionProtocol;
    }

    @Generated
    public void setAuditTransmissionProtocol(AuditTransmissionProtocol auditTransmissionProtocol) {
        this.auditTransmissionProtocol = auditTransmissionProtocol;
    }

    @Override
    @Generated
    public AuditMessageQueue getAuditMessageQueue() {
        return this.auditMessageQueue;
    }

    @Generated
    public void setAuditMessageQueue(AuditMessageQueue auditMessageQueue) {
        this.auditMessageQueue = auditMessageQueue;
    }

    @Override
    @Generated
    public String getAuditSourceId() {
        return this.auditSourceId;
    }

    @Generated
    public void setAuditSourceId(String auditSourceId) {
        this.auditSourceId = auditSourceId;
    }

    @Override
    @Generated
    public String getAuditEnterpriseSiteId() {
        return this.auditEnterpriseSiteId;
    }

    @Generated
    public void setAuditEnterpriseSiteId(String auditEnterpriseSiteId) {
        this.auditEnterpriseSiteId = auditEnterpriseSiteId;
    }

    @Override
    @Generated
    public AuditSource getAuditSource() {
        return this.auditSource;
    }

    @Generated
    public void setAuditSource(AuditSource auditSource) {
        this.auditSource = auditSource;
    }

    @Override
    @Generated
    public SerializationStrategy getSerializationStrategy() {
        return this.serializationStrategy;
    }

    @Generated
    public void setSerializationStrategy(SerializationStrategy serializationStrategy) {
        this.serializationStrategy = serializationStrategy;
    }

    @Override
    @Generated
    public AuditMessagePostProcessor getAuditMessagePostProcessor() {
        return this.auditMessagePostProcessor;
    }

    @Generated
    public void setAuditMessagePostProcessor(AuditMessagePostProcessor auditMessagePostProcessor) {
        this.auditMessagePostProcessor = auditMessagePostProcessor;
    }

    @Override
    @Generated
    public AuditExceptionHandler getAuditExceptionHandler() {
        return this.auditExceptionHandler;
    }

    @Generated
    public void setAuditExceptionHandler(AuditExceptionHandler auditExceptionHandler) {
        this.auditExceptionHandler = auditExceptionHandler;
    }

    @Override
    @Generated
    public AuditMetadataProvider getAuditMetadataProvider() {
        return this.auditMetadataProvider;
    }

    @Generated
    public void setAuditMetadataProvider(AuditMetadataProvider auditMetadataProvider) {
        this.auditMetadataProvider = auditMetadataProvider;
    }

    @Override
    @Generated
    public TlsParameters getTlsParameters() {
        return this.tlsParameters;
    }

    @Generated
    public void setTlsParameters(TlsParameters tlsParameters) {
        this.tlsParameters = tlsParameters;
    }

    @Override
    @Generated
    public boolean isIncludeParticipantsFromResponse() {
        return this.includeParticipantsFromResponse;
    }

    @Generated
    public void setIncludeParticipantsFromResponse(boolean includeParticipantsFromResponse) {
        this.includeParticipantsFromResponse = includeParticipantsFromResponse;
    }

    @Override
    @Generated
    public String getAuditValueIfMissing() {
        return this.auditValueIfMissing;
    }

    @Generated
    public void setAuditValueIfMissing(String auditValueIfMissing) {
        this.auditValueIfMissing = auditValueIfMissing;
    }

    @Generated
    public void setWsAuditDatasetEnricher(WsAuditDatasetEnricher wsAuditDatasetEnricher) {
        this.wsAuditDatasetEnricher = wsAuditDatasetEnricher;
    }

    @Generated
    public void setFhirAuditDatasetEnricher(FhirAuditDatasetEnricher fhirAuditDatasetEnricher) {
        this.fhirAuditDatasetEnricher = fhirAuditDatasetEnricher;
    }

    @Override
    @Generated
    public ContextRegistry getContextRegistry() {
        return this.contextRegistry;
    }
}

