/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit;

import java.io.IOException;
import java.io.InputStream;
import java.net.InetAddress;
import java.net.Socket;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Paths;
import java.security.KeyManagementException;
import java.security.KeyStore;
import java.security.Principal;
import java.security.PrivateKey;
import java.security.SecureRandom;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.net.ssl.KeyManager;
import javax.net.ssl.KeyManagerFactory;
import javax.net.ssl.SNIHostName;
import javax.net.ssl.SSLContext;
import javax.net.ssl.SSLContextSpi;
import javax.net.ssl.SSLEngine;
import javax.net.ssl.SSLParameters;
import javax.net.ssl.SSLServerSocketFactory;
import javax.net.ssl.SSLSessionContext;
import javax.net.ssl.SSLSocket;
import javax.net.ssl.SSLSocketFactory;
import javax.net.ssl.TrustManager;
import javax.net.ssl.TrustManagerFactory;
import javax.net.ssl.X509ExtendedKeyManager;
import javax.net.ssl.X509KeyManager;
import org.openehealth.ipf.commons.audit.TlsParameters;

public class CustomTlsParameters
implements TlsParameters {
    protected String provider = "SunJSSE";
    protected String tlsProtocol = "TLSv1.2";
    protected String certificateType = "SunX509";
    protected String certAlias;
    protected String keyStoreType;
    protected String trustStoreType;
    protected String keyStoreFile;
    protected String keyStorePassword;
    protected String trustStoreFile;
    protected String trustStorePassword;
    protected String enabledClientCipherSuites;
    protected String enabledServerCipherSuites;
    protected String enabledProtocols;
    protected int sessionTimeout;
    protected boolean performDomainValidation;
    protected List<String> sniHostnames = new ArrayList<String>();
    protected String clientAuthentication;

    static TlsParameters getDefault() {
        return new CustomTlsParameters();
    }

    public void setProvider(String provider) {
        this.provider = provider;
    }

    public void setTlsProtocol(String tlsProtocol) {
        this.tlsProtocol = tlsProtocol;
    }

    public void setKeyStoreType(String keyStoreType) {
        this.keyStoreType = keyStoreType;
    }

    public void setTrustStoreType(String trustStoreType) {
        this.trustStoreType = trustStoreType;
    }

    public void setCertificateType(String certificateType) {
        this.certificateType = certificateType;
    }

    public void setCertAlias(String certAlias) {
        this.certAlias = certAlias;
    }

    public void setKeyStoreFile(String keyStoreFile) {
        this.keyStoreFile = keyStoreFile;
    }

    public void setKeyStorePassword(String keyStorePassword) {
        this.keyStorePassword = keyStorePassword;
    }

    public void setTrustStoreFile(String trustStoreFile) {
        this.trustStoreFile = trustStoreFile;
    }

    public void setTrustStorePassword(String trustStorePassword) {
        this.trustStorePassword = trustStorePassword;
    }

    public void setEnabledClientCipherSuites(String enabledClientCipherSuites) {
        this.enabledClientCipherSuites = enabledClientCipherSuites;
    }

    public void setEnabledServerCipherSuites(String enabledServerCipherSuites) {
        this.enabledServerCipherSuites = enabledServerCipherSuites;
    }

    public void setEnabledProtocols(String enabledProtocols) {
        this.enabledProtocols = enabledProtocols;
    }

    public void setSessionTimeout(int sessionTimeout) {
        this.sessionTimeout = sessionTimeout;
    }

    public void setPerformDomainValidation(boolean performDomainValidation) {
        this.performDomainValidation = performDomainValidation;
    }

    public String getClientAuthentication() {
        return this.clientAuthentication;
    }

    public void setClientAuthentication(String clientAuthentication) {
        this.clientAuthentication = clientAuthentication;
    }

    public List<String> getSniHostnames() {
        return this.sniHostnames;
    }

    public void setSniHostnames(List<String> sniHostnames) {
        this.sniHostnames = sniHostnames;
    }

    public CustomTlsParameters() {
        this.trustStoreType = this.keyStoreType = System.getProperty("javax.net.ssl.keyStoreType", KeyStore.getDefaultType());
        this.keyStoreFile = System.getProperty("javax.net.ssl.keyStore");
        this.keyStorePassword = System.getProperty("javax.net.ssl.keyStorePassword");
        this.trustStoreFile = System.getProperty("javax.net.ssl.trustStore");
        this.trustStorePassword = System.getProperty("javax.net.ssl.trustStorePassword");
        this.enabledClientCipherSuites = System.getProperty("jdk.tls.client.cipherSuites");
        this.enabledServerCipherSuites = System.getProperty("jdk.tls.server.cipherSuites");
        this.enabledProtocols = System.getProperty("jdk.tls.client.protocols", "TLSv1.2");
    }

    private Function<SSLSocketFactory, SSLSocketFactory> sslSocketFactoryConfigurer(boolean serverSide) {
        return sslSocketFactory -> new SSLSocketFactoryDecorator((SSLSocketFactory)sslSocketFactory, this.sslSocketConfigurer(serverSide));
    }

    private Function<SSLSocket, SSLSocket> sslSocketConfigurer(boolean serverSide) {
        return sslSocket -> {
            SSLParameters sslParameters;
            if (!serverSide && this.enabledClientCipherSuites != null) {
                sslSocket.setEnabledCipherSuites(this.split(this.enabledClientCipherSuites));
            }
            if (serverSide && this.enabledServerCipherSuites != null) {
                sslSocket.setEnabledCipherSuites(this.split(this.enabledServerCipherSuites));
            }
            if (this.enabledProtocols != null) {
                sslSocket.setEnabledProtocols(this.split(this.enabledProtocols));
            }
            if (this.sniHostnames.isEmpty()) {
                sslParameters = sslSocket.getSSLParameters();
                sslParameters.setServerNames(this.sniHostnames.stream().map(SNIHostName::new).collect(Collectors.toList()));
                sslSocket.setSSLParameters(sslParameters);
            }
            if (this.performDomainValidation) {
                sslParameters = sslSocket.getSSLParameters();
                sslParameters.setEndpointIdentificationAlgorithm("HTTPS");
                sslSocket.setSSLParameters(sslParameters);
            }
            return sslSocket;
        };
    }

    private Function<SSLEngine, SSLEngine> sslEngineConfigurer(boolean serverSide) {
        return sslEngine -> {
            if (!serverSide && this.enabledClientCipherSuites != null) {
                sslEngine.setEnabledCipherSuites(this.split(this.enabledClientCipherSuites));
            }
            if (serverSide && this.enabledServerCipherSuites != null) {
                sslEngine.setEnabledCipherSuites(this.split(this.enabledClientCipherSuites));
            }
            if (this.enabledProtocols != null) {
                sslEngine.setEnabledProtocols(this.split(this.enabledProtocols));
            }
            return sslEngine;
        };
    }

    protected String[] split(String s) {
        return s.split("\\s*,\\s*");
    }

    @Override
    public SSLContext getSSLContext(boolean serverSide) {
        try {
            KeyStore keyStore = this.getKeyStore(this.keyStoreType, this.keyStoreFile, this.keyStorePassword);
            KeyManagerFactory keyManagerFactory = KeyManagerFactory.getInstance(this.certificateType, this.provider);
            keyManagerFactory.init(keyStore, this.keyStorePassword.toCharArray());
            KeyManager[] keyManagers = keyManagerFactory.getKeyManagers();
            if (keyManagers != null && this.certAlias != null) {
                for (int i = 0; i < keyManagers.length; ++i) {
                    KeyManager keyManager = keyManagers[i];
                    if (!(keyManager instanceof X509KeyManager)) continue;
                    X509KeyManager x509KeyManager = (X509KeyManager)keyManager;
                    keyManagers[i] = new AliasX509ExtendedKeyManager(x509KeyManager, this.certAlias);
                }
            }
            KeyStore trustStore = this.getKeyStore(this.trustStoreType, this.trustStoreFile, this.trustStorePassword);
            TrustManagerFactory trustManagerFactory = TrustManagerFactory.getInstance(this.certificateType, this.provider);
            trustManagerFactory.init(trustStore);
            TrustManager[] trustManagers = trustManagerFactory.getTrustManagers();
            SecureRandom secureRandom = new SecureRandom();
            SSLContext sslContext = SSLContext.getInstance(this.tlsProtocol, this.provider);
            sslContext.init(keyManagers, trustManagers, secureRandom);
            if (this.sessionTimeout > 0) {
                sslContext.getClientSessionContext().setSessionTimeout(this.sessionTimeout);
            }
            return new CustomSSLContext(new SSLContextSpiDecorator(sslContext, this.sslEngineConfigurer(serverSide), this.sslSocketFactoryConfigurer(serverSide)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    private KeyStore getKeyStore(String type, String storePath, String password) throws Exception {
        KeyStore keyStore = KeyStore.getInstance(type);
        try (InputStream in = Files.newInputStream(Paths.get(storePath, new String[0]), new OpenOption[0]);){
            keyStore.load(in, password.toCharArray());
            KeyStore keyStore2 = keyStore;
            return keyStore2;
        }
    }

    private static final class AliasX509ExtendedKeyManager
    extends X509ExtendedKeyManager {
        private final String certAlias;
        private final X509KeyManager keyManager;

        public AliasX509ExtendedKeyManager(X509KeyManager keyManager, String certAlias) {
            this.keyManager = keyManager;
            this.certAlias = certAlias;
        }

        @Override
        public String chooseClientAlias(String[] keyTypes, Principal[] issuers, Socket socket) {
            return this.certAlias != null ? this.certAlias : this.keyManager.chooseClientAlias(keyTypes, issuers, socket);
        }

        @Override
        public String chooseServerAlias(String keyType, Principal[] issuers, Socket socket) {
            return this.certAlias != null ? this.certAlias : this.keyManager.chooseServerAlias(keyType, issuers, socket);
        }

        @Override
        public String chooseEngineServerAlias(String keyType, Principal[] issuers, SSLEngine engine) {
            return this.certAlias != null ? this.certAlias : super.chooseEngineServerAlias(keyType, issuers, engine);
        }

        @Override
        public String chooseEngineClientAlias(String[] keyTypes, Principal[] issuers, SSLEngine engine) {
            return this.certAlias != null ? this.certAlias : super.chooseEngineClientAlias(keyTypes, issuers, engine);
        }

        @Override
        public String[] getClientAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getClientAliases(keyType, issuers);
        }

        @Override
        public String[] getServerAliases(String keyType, Principal[] issuers) {
            return this.keyManager.getServerAliases(keyType, issuers);
        }

        @Override
        public X509Certificate[] getCertificateChain(String alias) {
            return this.keyManager.getCertificateChain(alias);
        }

        @Override
        public PrivateKey getPrivateKey(String alias) {
            return this.keyManager.getPrivateKey(alias);
        }
    }

    private static final class CustomSSLContext
    extends SSLContext {
        CustomSSLContext(SSLContextSpiDecorator sslContextSpiDecorator) {
            super(sslContextSpiDecorator, sslContextSpiDecorator.getDelegate().getProvider(), sslContextSpiDecorator.getDelegate().getProtocol());
        }
    }

    private static final class SSLContextSpiDecorator
    extends SSLContextSpi {
        private final SSLContext sslContext;
        private final Function<SSLEngine, SSLEngine> sslEngineConfigurer;
        private final Function<SSLSocketFactory, SSLSocketFactory> sslSocketFactoryConfigurer;

        public SSLContextSpiDecorator(SSLContext sslContext, Function<SSLEngine, SSLEngine> sslEngineConfigurer, Function<SSLSocketFactory, SSLSocketFactory> sslSocketFactoryConfigurer) {
            this.sslContext = sslContext;
            this.sslEngineConfigurer = sslEngineConfigurer;
            this.sslSocketFactoryConfigurer = sslSocketFactoryConfigurer;
        }

        SSLContext getDelegate() {
            return this.sslContext;
        }

        @Override
        protected void engineInit(KeyManager[] keyManagers, TrustManager[] trustManagers, SecureRandom secureRandom) throws KeyManagementException {
            this.sslContext.init(keyManagers, trustManagers, secureRandom);
        }

        @Override
        protected SSLSocketFactory engineGetSocketFactory() {
            SSLSocketFactory factory = this.sslContext.getSocketFactory();
            return this.sslSocketFactoryConfigurer.apply(factory);
        }

        @Override
        protected SSLServerSocketFactory engineGetServerSocketFactory() {
            throw new UnsupportedOperationException();
        }

        @Override
        protected SSLEngine engineCreateSSLEngine() {
            SSLEngine engine = this.sslContext.createSSLEngine();
            return this.sslEngineConfigurer.apply(engine);
        }

        @Override
        protected SSLEngine engineCreateSSLEngine(String host, int port) {
            SSLEngine engine = this.sslContext.createSSLEngine(host, port);
            return this.sslEngineConfigurer.apply(engine);
        }

        @Override
        protected SSLSessionContext engineGetServerSessionContext() {
            return this.sslContext.getServerSessionContext();
        }

        @Override
        protected SSLSessionContext engineGetClientSessionContext() {
            return this.sslContext.getClientSessionContext();
        }
    }

    private static final class SSLSocketFactoryDecorator
    extends SSLSocketFactory {
        private final SSLSocketFactory delegate;
        private final Function<SSLSocket, SSLSocket> sslSocketConfigurer;

        public SSLSocketFactoryDecorator(SSLSocketFactory delegate, Function<SSLSocket, SSLSocket> sslSocketConfigurer) {
            this.delegate = delegate;
            this.sslSocketConfigurer = sslSocketConfigurer;
        }

        @Override
        public String[] getDefaultCipherSuites() {
            return this.delegate.getDefaultCipherSuites();
        }

        @Override
        public String[] getSupportedCipherSuites() {
            return this.delegate.getSupportedCipherSuites();
        }

        @Override
        public Socket createSocket() throws IOException {
            return this.configureSocket(this.delegate.createSocket());
        }

        @Override
        public Socket createSocket(Socket s, String host, int port, boolean autoClose) throws IOException {
            return this.configureSocket(this.delegate.createSocket(s, host, port, autoClose));
        }

        @Override
        public Socket createSocket(String host, int port) throws IOException {
            return this.configureSocket(this.delegate.createSocket(host, port));
        }

        @Override
        public Socket createSocket(String host, int port, InetAddress localHost, int localPort) throws IOException {
            return this.configureSocket(this.delegate.createSocket(host, port, localHost, localPort));
        }

        @Override
        public Socket createSocket(InetAddress host, int port) throws IOException {
            return this.configureSocket(this.delegate.createSocket(host, port));
        }

        @Override
        public Socket createSocket(InetAddress address, int port, InetAddress localAddress, int localPort) throws IOException {
            return this.configureSocket(this.delegate.createSocket(address, port, localAddress, localPort));
        }

        public SSLSocketFactory getDelegate() {
            return this.delegate;
        }

        private Socket configureSocket(Socket s) {
            SSLSocket socket = (SSLSocket)s;
            return this.sslSocketConfigurer.apply(socket);
        }
    }
}

