/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit;

import io.micrometer.context.ContextRegistry;
import java.net.InetAddress;
import java.util.stream.Stream;
import org.openehealth.ipf.commons.audit.AuditMessagePostProcessor;
import org.openehealth.ipf.commons.audit.AuditMetadataProvider;
import org.openehealth.ipf.commons.audit.DefaultAuditContext;
import org.openehealth.ipf.commons.audit.FhirAuditDatasetEnricher;
import org.openehealth.ipf.commons.audit.TlsParameters;
import org.openehealth.ipf.commons.audit.WsAuditDatasetEnricher;
import org.openehealth.ipf.commons.audit.handler.AuditExceptionHandler;
import org.openehealth.ipf.commons.audit.marshal.SerializationStrategy;
import org.openehealth.ipf.commons.audit.marshal.dicom.Current;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionProtocol;
import org.openehealth.ipf.commons.audit.queue.AuditMessageQueue;
import org.openehealth.ipf.commons.audit.types.AuditSource;

public interface AuditContext {
    public boolean isAuditEnabled();

    public String getAuditRepositoryHostName();

    public InetAddress getAuditRepositoryAddress();

    public int getAuditRepositoryPort();

    public String getSendingApplication();

    public AuditTransmissionProtocol getAuditTransmissionProtocol();

    public AuditMessageQueue getAuditMessageQueue();

    public TlsParameters getTlsParameters();

    public <T extends WsAuditDatasetEnricher> T getWsAuditDatasetEnricher();

    public <T extends FhirAuditDatasetEnricher> T getFhirAuditDatasetEnricher();

    default public AuditMessagePostProcessor getAuditMessagePostProcessor() {
        return AuditMessagePostProcessor.noOp();
    }

    default public SerializationStrategy getSerializationStrategy() {
        return Current.INSTANCE;
    }

    default public void audit(AuditMessage ... messages) {
        if (this.isAuditEnabled() && messages != null) {
            this.getAuditMessageQueue().audit(this, (AuditMessage[])Stream.of(messages).map(this.getAuditMessagePostProcessor()).toArray(AuditMessage[]::new));
        }
    }

    default public AuditMetadataProvider getAuditMetadataProvider() {
        return AuditMetadataProvider.getDefault();
    }

    default public String getAuditValueIfMissing() {
        return "UNKNOWN";
    }

    public String getAuditSourceId();

    public String getAuditEnterpriseSiteId();

    public AuditSource getAuditSource();

    public AuditExceptionHandler getAuditExceptionHandler();

    public boolean isIncludeParticipantsFromResponse();

    public ContextRegistry getContextRegistry();

    public static AuditContext noAudit() {
        return DefaultAuditContext.NO_AUDIT;
    }
}

