/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.utils;

import java.lang.management.ManagementFactory;
import java.lang.management.RuntimeMXBean;
import java.net.DatagramSocket;
import java.net.InetAddress;
import java.util.Map;
import java.util.Optional;
import java.util.concurrent.ConcurrentHashMap;

public class AuditUtils {
    private static final Map<String, String> systemData = new ConcurrentHashMap<String, String>();
    private static final String PID = "PID";
    private static final String IP = "IP";
    private static final String HOST = "HOST";
    private static final String USER = "USER";

    public static String getProcessId() {
        return systemData.computeIfAbsent(PID, s -> {
            RuntimeMXBean mx = ManagementFactory.getRuntimeMXBean();
            String name = mx.getName();
            int pointer = name.indexOf(64);
            if (pointer != -1) {
                return name.substring(0, pointer);
            }
            return "unknown";
        });
    }

    public static String getLocalIPAddress() {
        return systemData.computeIfAbsent(IP, s -> AuditUtils.localInetAddress().map(InetAddress::getHostAddress).orElse("unknown")).trim();
    }

    public static String getLocalHostName() {
        return systemData.computeIfAbsent(HOST, s -> AuditUtils.localInetAddress().map(InetAddress::getCanonicalHostName).orElse("unknown")).trim();
    }

    public static String getUserName() {
        return systemData.computeIfAbsent(USER, s -> System.getProperty("user.name"));
    }

    public static String getHostFromUrl(String url) {
        if (url == null) {
            return null;
        }
        int pos = url.indexOf("://");
        if (pos > 0) {
            url = url.substring(pos + 3);
        }
        if ((pos = url.indexOf(64)) > 0) {
            url = url.substring(pos + 1);
        }
        for (int i = 0; i < url.length(); ++i) {
            char c = url.charAt(i);
            if (c != ':' && c != '?' && c != '/' && c != '#') continue;
            return url.substring(0, i);
        }
        return url;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Optional<InetAddress> localInetAddress() {
        try (DatagramSocket socket = new DatagramSocket();){
            socket.connect(InetAddress.getByName("8.8.8.8"), 10002);
            Optional<InetAddress> optional = Optional.of(socket.getLocalAddress());
            return optional;
        }
        catch (Exception e) {
            return Optional.empty();
        }
    }
}

