/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.queue;

import java.util.Objects;
import javax.jms.Connection;
import javax.jms.ConnectionFactory;
import javax.jms.Destination;
import javax.jms.Message;
import javax.jms.MessageProducer;
import javax.jms.Queue;
import javax.jms.Session;
import javax.jms.TextMessage;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.queue.AbstractAuditMessageQueue;

public class JmsAuditMessageQueue
extends AbstractAuditMessageQueue {
    private final ConnectionFactory connectionFactory;
    private final String queueName;
    private final String userName;
    private final String password;

    public JmsAuditMessageQueue(ConnectionFactory connectionFactory, String queueName, String userName, String password) {
        this.connectionFactory = Objects.requireNonNull(connectionFactory, "ConnectionFactory must not be null");
        this.queueName = queueName != null ? queueName : "atna-audit";
        this.userName = userName;
        this.password = password;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected void handle(AuditContext auditContext, String auditMessage) {
        try {
            connection.start();
            try (Connection connection = this.userName == null ? this.connectionFactory.createConnection() : this.connectionFactory.createConnection(this.userName, this.password);){
                Session session = connection.createSession(false, 1);
                Queue queue = session.createQueue(this.queueName);
                MessageProducer producer = session.createProducer((Destination)queue);
                TextMessage message = session.createTextMessage(auditMessage);
                message.setStringProperty("X-IPF-ATNA-Timestamp", auditContext.getAuditMetadataProvider().getTimestamp());
                message.setStringProperty("X-IPF-ATNA-Hostname", auditContext.getAuditMetadataProvider().getHostname());
                message.setStringProperty("X-IPF-ATNA-ProcessID", auditContext.getAuditMetadataProvider().getProcessID());
                message.setStringProperty("X-IPF-ATNA-Application", auditContext.getSendingApplication());
                producer.send((Message)message);
            }
        }
        catch (Exception e) {
            auditContext.getAuditExceptionHandler().handleException(auditContext, e, auditMessage);
        }
    }
}

