/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.queue;

import java.util.Map;
import java.util.concurrent.CompletableFuture;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.TimeUnit;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.queue.AbstractAuditMessageQueue;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.slf4j.MDC;

public class AsynchronousAuditMessageQueue
extends AbstractAuditMessageQueue {
    private static final Logger LOG = LoggerFactory.getLogger(AsynchronousAuditMessageQueue.class);
    private ExecutorService executorService;
    private int shutdownTimeoutSeconds = 30;

    public void setExecutorService(ExecutorService executorService) {
        this.executorService = executorService;
    }

    public void setShutdownTimeoutSeconds(int shutdownTimeoutSeconds) {
        this.shutdownTimeoutSeconds = shutdownTimeoutSeconds;
    }

    @Override
    protected void handle(AuditContext auditContext, String auditRecord) {
        if (auditRecord != null) {
            Runnable runnable = this.runnable(auditContext, auditRecord);
            if (this.executorService != null && !this.executorService.isShutdown()) {
                CompletableFuture.runAsync(runnable, this.executorService).exceptionally(e -> {
                    auditContext.getAuditExceptionHandler().handleException(auditContext, (Throwable)e, auditRecord);
                    return null;
                });
            } else {
                runnable.run();
            }
        }
    }

    private Runnable runnable(AuditContext auditContext, String auditRecord) {
        Map mdcContextMap = MDC.getCopyOfContextMap();
        return () -> {
            try {
                MDC.setContextMap((Map)mdcContextMap);
                auditContext.getAuditTransmissionProtocol().send(auditContext, auditRecord);
            }
            catch (Exception e) {
                throw new AuditException(e);
            }
            finally {
                MDC.clear();
            }
        };
    }

    @Override
    public void shutdown() {
        if (this.executorService != null) {
            this.executorService.shutdown();
            try {
                if (!this.executorService.awaitTermination(this.shutdownTimeoutSeconds, TimeUnit.SECONDS)) {
                    LOG.warn("Timeout occurred when flushing Audit events, some events might have been lost");
                    this.executorService.shutdownNow();
                }
            }
            catch (InterruptedException e) {
                LOG.warn("Thread interrupt when flushing ATNA events, some events might have been lost", (Throwable)e);
            }
        }
    }
}

