/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.protocol;

import io.vertx.core.Vertx;
import io.vertx.core.buffer.impl.BufferImpl;
import io.vertx.core.net.NetClient;
import io.vertx.core.net.NetClientOptions;
import io.vertx.core.net.NetSocket;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicReference;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.TlsParameters;
import org.openehealth.ipf.commons.audit.VertxTlsParameters;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionChannel;
import org.openehealth.ipf.commons.audit.protocol.NioTLSSyslogSenderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class VertxTLSSyslogSenderImpl
extends NioTLSSyslogSenderImpl<String, VertxDestination> {
    private static final Logger LOG = LoggerFactory.getLogger(VertxTLSSyslogSenderImpl.class);
    private final Vertx vertx;

    public VertxTLSSyslogSenderImpl() {
        this(VertxTlsParameters.getDefault());
    }

    public VertxTLSSyslogSenderImpl(TlsParameters tlsParameters) {
        this(Vertx.vertx(), tlsParameters);
    }

    public VertxTLSSyslogSenderImpl(Vertx vertx) {
        this(vertx, VertxTlsParameters.getDefault());
    }

    public VertxTLSSyslogSenderImpl(Vertx vertx, TlsParameters tlsParameters) {
        super(tlsParameters);
        this.vertx = vertx;
    }

    @Override
    protected VertxDestination makeDestination(TlsParameters tlsParameters, String host, int port, boolean logging) {
        return new VertxDestination(this.vertx, (VertxTlsParameters)tlsParameters, host, port);
    }

    @Override
    public String getTransportName() {
        return AuditTransmissionChannel.VERTX_TLS.getProtocolName();
    }

    @Override
    protected void customizeDestination(VertxDestination destination) {
    }

    public static class VertxDestination
    implements NioTLSSyslogSenderImpl.Destination<String> {
        private final Vertx vertx;
        private final VertxTlsParameters tlsParameters;
        private final String host;
        private final int port;
        private final AtomicReference<String> writeHandlerId = new AtomicReference();

        public VertxDestination(Vertx vertx, VertxTlsParameters tlsParameters, String host, int port) {
            this.vertx = vertx;
            this.tlsParameters = tlsParameters;
            this.host = host;
            this.port = port;
        }

        @Override
        public void write(byte[] ... bytes) {
            BufferImpl buffer = new BufferImpl();
            for (byte[] b : bytes) {
                buffer.appendBytes(b);
            }
            this.vertx.eventBus().send(this.getHandle(), (Object)buffer);
        }

        @Override
        public void shutdown() {
            this.vertx.close();
        }

        @Override
        public String getHandle() {
            if (this.writeHandlerId.get() == null) {
                CountDownLatch latch = new CountDownLatch(1);
                NetClientOptions options = new NetClientOptions().setConnectTimeout(1000).setReconnectAttempts(5).setReconnectInterval(1000L).setSsl(true);
                this.tlsParameters.initNetClientOptions(options);
                NetClient client = this.vertx.createNetClient(options);
                client.connect(this.port, this.host, event -> {
                    LOG.info("Attempt to connect to {}:{}, : {}", new Object[]{this.host, this.port, event.succeeded()});
                    if (event.succeeded()) {
                        NetSocket socket = (NetSocket)event.result();
                        socket.exceptionHandler(exceptionEvent -> {
                            LOG.info("Audit Connection caught exception", exceptionEvent);
                            this.writeHandlerId.set(null);
                            client.close();
                        }).closeHandler(closeEvent -> {
                            LOG.info("Audit Connection closed");
                            this.writeHandlerId.set(null);
                            client.close();
                        });
                        this.writeHandlerId.compareAndSet(null, socket.writeHandlerID());
                        latch.countDown();
                    }
                });
                try {
                    latch.await(5000L, TimeUnit.MILLISECONDS);
                }
                catch (InterruptedException e) {
                    throw new AuditException(String.format("Could not establish TLS connection to %s:%d", this.host, this.port));
                }
            }
            return this.writeHandlerId.get();
        }
    }
}

