/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.protocol;

import io.netty.bootstrap.Bootstrap;
import io.netty.buffer.Unpooled;
import io.netty.channel.Channel;
import io.netty.channel.ChannelFuture;
import io.netty.channel.ChannelHandler;
import io.netty.channel.ChannelHandlerContext;
import io.netty.channel.ChannelInboundHandlerAdapter;
import io.netty.channel.ChannelInitializer;
import io.netty.channel.ChannelOption;
import io.netty.channel.ChannelPipeline;
import io.netty.channel.EventLoopGroup;
import io.netty.channel.nio.NioEventLoopGroup;
import io.netty.channel.socket.SocketChannel;
import io.netty.channel.socket.nio.NioSocketChannel;
import io.netty.handler.logging.LogLevel;
import io.netty.handler.logging.LoggingHandler;
import io.netty.handler.ssl.ApplicationProtocolConfig;
import io.netty.handler.ssl.CipherSuiteFilter;
import io.netty.handler.ssl.ClientAuth;
import io.netty.handler.ssl.JdkSslContext;
import io.netty.handler.ssl.SslContext;
import io.netty.handler.ssl.SupportedCipherSuiteFilter;
import java.util.concurrent.TimeUnit;
import java.util.stream.Stream;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.TlsParameters;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionChannel;
import org.openehealth.ipf.commons.audit.protocol.NioTLSSyslogSenderImpl;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class NettyTLSSyslogSenderImpl
extends NioTLSSyslogSenderImpl<ChannelFuture, NettyDestination> {
    private static final Logger LOG = LoggerFactory.getLogger(NettyTLSSyslogSenderImpl.class);
    private int workerThreads = 1;
    private long connectTimeoutMillis = 5000L;
    private long sendTimeoutMillis = 5000L;

    public NettyTLSSyslogSenderImpl(TlsParameters tlsParameters) {
        super(tlsParameters);
    }

    @Override
    public String getTransportName() {
        return AuditTransmissionChannel.NETTY_TLS.getProtocolName();
    }

    @Override
    protected NettyDestination makeDestination(TlsParameters tlsParameters, String host, int port, boolean logging) {
        return new NettyDestination(tlsParameters, host, port, this.workerThreads, this.connectTimeoutMillis, this.sendTimeoutMillis, logging);
    }

    @Override
    protected void customizeDestination(NettyDestination destination) {
    }

    public void setConnectTimeout(int value, TimeUnit timeUnit) {
        this.connectTimeoutMillis = timeUnit.toMillis(value);
    }

    public void setSendTimeout(int value, TimeUnit timeUnit) {
        this.sendTimeoutMillis = timeUnit.toMillis(value);
    }

    public void setWorkerThreads(int workerThreads) {
        this.workerThreads = workerThreads;
    }

    public static final class NettyDestination
    implements NioTLSSyslogSenderImpl.Destination<ChannelFuture> {
        private final long connectTimeout;
        private final long sendTimeout;
        private final Bootstrap bootstrap;
        private final EventLoopGroup workerGroup;
        private ChannelFuture channelFuture;
        private final String host;
        private final int port;

        public Bootstrap getBootstrap() {
            return this.bootstrap;
        }

        NettyDestination(TlsParameters tlsParameters, String host, int port, int workerThreads, long connectTimeout, long sendTimeout, boolean withLogging) {
            this.workerGroup = new NioEventLoopGroup(workerThreads);
            this.connectTimeout = connectTimeout;
            this.sendTimeout = sendTimeout;
            this.host = host;
            this.port = port;
            this.bootstrap = (Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)((Bootstrap)new Bootstrap().group(this.workerGroup)).channel(NioSocketChannel.class)).option(ChannelOption.CONNECT_TIMEOUT_MILLIS, (Object)((int)connectTimeout))).option(ChannelOption.SO_KEEPALIVE, (Object)true)).remoteAddress(host, port).handler((ChannelHandler)new InitializerHandler(tlsParameters, host, port, withLogging));
        }

        @Override
        public void shutdown() {
            if (this.workerGroup != null) {
                LOG.info("TLS Channel to Audit Repository at {}:{} is closed", (Object)this.host, (Object)this.port);
                this.workerGroup.shutdownGracefully();
            }
        }

        @Override
        public ChannelFuture getHandle() {
            if (this.channelFuture == null || !this.channelFuture.channel().isActive()) {
                try {
                    this.channelFuture = this.bootstrap.connect();
                    if (this.channelFuture == null || !this.channelFuture.await(this.connectTimeout)) {
                        throw new AuditException("Could not establish TLS connection to " + this.host + ":" + this.port);
                    }
                }
                catch (InterruptedException e) {
                    throw new AuditException("Interrupted while establishing TLS connection to " + this.host + ":" + this.port, e);
                }
            }
            return this.channelFuture;
        }

        @Override
        public void write(byte[] ... bytes) {
            Channel channel = this.getHandle().channel();
            LOG.trace("Writing {} bytes using session: {}", (Object)bytes.length, (Object)channel);
            try {
                if (!channel.writeAndFlush((Object)Unpooled.wrappedBuffer((byte[][])bytes)).await(this.sendTimeout)) {
                    throw new AuditException("Could not send audit message to " + this.host + ":" + this.port);
                }
            }
            catch (InterruptedException e) {
                throw new AuditException("Interrupted during sending audit message to " + this.host + ":" + this.port, e);
            }
        }

        private static class InitializerHandler
        extends ChannelInitializer<SocketChannel> {
            private final TlsParameters tlsParameters;
            private final String host;
            private final int port;
            private final boolean withLogging;

            public InitializerHandler(TlsParameters tlsParameters, String host, int port, boolean withLogging) {
                this.tlsParameters = tlsParameters;
                this.host = host;
                this.port = port;
                this.withLogging = withLogging;
            }

            protected void initChannel(SocketChannel channel) {
                ChannelPipeline pipeline = channel.pipeline();
                SslContext sslContext = this.initSslContext();
                pipeline.addLast(new ChannelHandler[]{sslContext.newHandler(channel.alloc(), this.host, this.port)});
                pipeline.addLast(new ChannelHandler[]{new InboundHandler(this.host, this.port)});
                if (this.withLogging) {
                    channel.pipeline().addLast(new ChannelHandler[]{new LoggingHandler(((Object)((Object)this)).getClass(), LogLevel.DEBUG)});
                }
            }

            private SslContext initSslContext() {
                String allowedProtocols = System.getProperty("jdk.tls.client.protocols", "TLSv1.2");
                String[] protocols = (String[])Stream.of(allowedProtocols.split("\\s*,\\s*")).toArray(String[]::new);
                return new JdkSslContext(this.tlsParameters.getSSLContext(), true, null, (CipherSuiteFilter)SupportedCipherSuiteFilter.INSTANCE, ApplicationProtocolConfig.DISABLED, ClientAuth.REQUIRE, protocols, false);
            }
        }

        private static class InboundHandler
        extends ChannelInboundHandlerAdapter {
            private final String host;
            private final int port;

            public InboundHandler(String host, int port) {
                this.host = host;
                this.port = port;
            }

            public void channelActive(ChannelHandlerContext ctx) throws Exception {
                LOG.info("TLS Channel to Audit Repository at {}:{} is now active", (Object)this.host, (Object)this.port);
                super.channelActive(ctx);
            }

            public void exceptionCaught(ChannelHandlerContext ctx, Throwable cause) {
                LOG.info("Exception on receiving message for context {}", (Object)ctx, (Object)cause);
                if (ctx != null) {
                    ctx.close();
                }
            }
        }
    }
}

