/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.model;

import java.io.Serializable;
import java.time.Instant;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.model.Validateable;
import org.openehealth.ipf.commons.audit.types.EventId;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;

public class EventIdentificationType
implements Serializable,
Validateable {
    @NonNull
    private EventId eventID;
    @NonNull
    private Instant eventDateTime;
    @NonNull
    private EventOutcomeIndicator eventOutcomeIndicator;
    private String eventOutcomeDescription;
    private EventActionCode eventActionCode;
    private List<PurposeOfUse> purposesOfUse;
    private List<EventType> eventTypeCodes;

    public EventIdentificationType(EventId eventID, Instant eventDateTime, EventOutcomeIndicator eventOutcomeIndicator) {
        this.eventID = Objects.requireNonNull(eventID, "eventID must be not null");
        this.eventDateTime = Objects.requireNonNull(eventDateTime, "eventDateTime must be not null");
        this.eventOutcomeIndicator = Objects.requireNonNull(eventOutcomeIndicator, "eventOutcomeIndicator must be not null");
    }

    public List<EventType> getEventTypeCode() {
        if (this.eventTypeCodes == null) {
            this.eventTypeCodes = new ArrayList<EventType>();
        }
        return this.eventTypeCodes;
    }

    public List<PurposeOfUse> getPurposesOfUse() {
        if (this.purposesOfUse == null) {
            this.purposesOfUse = new ArrayList<PurposeOfUse>();
        }
        return this.purposesOfUse;
    }

    @Override
    public void validate() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof EventIdentificationType)) {
            return false;
        }
        EventIdentificationType other = (EventIdentificationType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        EventId this$eventID = this.getEventID();
        EventId other$eventID = other.getEventID();
        if (this$eventID == null ? other$eventID != null : !this$eventID.equals(other$eventID)) {
            return false;
        }
        Instant this$eventDateTime = this.getEventDateTime();
        Instant other$eventDateTime = other.getEventDateTime();
        if (this$eventDateTime == null ? other$eventDateTime != null : !((Object)this$eventDateTime).equals(other$eventDateTime)) {
            return false;
        }
        EventOutcomeIndicator this$eventOutcomeIndicator = this.getEventOutcomeIndicator();
        EventOutcomeIndicator other$eventOutcomeIndicator = other.getEventOutcomeIndicator();
        if (this$eventOutcomeIndicator == null ? other$eventOutcomeIndicator != null : !this$eventOutcomeIndicator.equals(other$eventOutcomeIndicator)) {
            return false;
        }
        String this$eventOutcomeDescription = this.getEventOutcomeDescription();
        String other$eventOutcomeDescription = other.getEventOutcomeDescription();
        if (this$eventOutcomeDescription == null ? other$eventOutcomeDescription != null : !this$eventOutcomeDescription.equals(other$eventOutcomeDescription)) {
            return false;
        }
        EventActionCode this$eventActionCode = this.getEventActionCode();
        EventActionCode other$eventActionCode = other.getEventActionCode();
        if (this$eventActionCode == null ? other$eventActionCode != null : !this$eventActionCode.equals(other$eventActionCode)) {
            return false;
        }
        List<PurposeOfUse> this$purposesOfUse = this.getPurposesOfUse();
        List<PurposeOfUse> other$purposesOfUse = other.getPurposesOfUse();
        if (this$purposesOfUse == null ? other$purposesOfUse != null : !((Object)this$purposesOfUse).equals(other$purposesOfUse)) {
            return false;
        }
        List<EventType> this$eventTypeCodes = this.eventTypeCodes;
        List<EventType> other$eventTypeCodes = other.eventTypeCodes;
        return !(this$eventTypeCodes == null ? other$eventTypeCodes != null : !((Object)this$eventTypeCodes).equals(other$eventTypeCodes));
    }

    protected boolean canEqual(Object other) {
        return other instanceof EventIdentificationType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        EventId $eventID = this.getEventID();
        result = result * 59 + ($eventID == null ? 43 : $eventID.hashCode());
        Instant $eventDateTime = this.getEventDateTime();
        result = result * 59 + ($eventDateTime == null ? 43 : ((Object)$eventDateTime).hashCode());
        EventOutcomeIndicator $eventOutcomeIndicator = this.getEventOutcomeIndicator();
        result = result * 59 + ($eventOutcomeIndicator == null ? 43 : $eventOutcomeIndicator.hashCode());
        String $eventOutcomeDescription = this.getEventOutcomeDescription();
        result = result * 59 + ($eventOutcomeDescription == null ? 43 : $eventOutcomeDescription.hashCode());
        EventActionCode $eventActionCode = this.getEventActionCode();
        result = result * 59 + ($eventActionCode == null ? 43 : $eventActionCode.hashCode());
        List<PurposeOfUse> $purposesOfUse = this.getPurposesOfUse();
        result = result * 59 + ($purposesOfUse == null ? 43 : ((Object)$purposesOfUse).hashCode());
        List<EventType> $eventTypeCodes = this.eventTypeCodes;
        result = result * 59 + ($eventTypeCodes == null ? 43 : ((Object)$eventTypeCodes).hashCode());
        return result;
    }

    @NonNull
    public EventId getEventID() {
        return this.eventID;
    }

    public void setEventID(@NonNull EventId eventID) {
        if (eventID == null) {
            throw new NullPointerException("eventID is marked non-null but is null");
        }
        this.eventID = eventID;
    }

    @NonNull
    public Instant getEventDateTime() {
        return this.eventDateTime;
    }

    public void setEventDateTime(@NonNull Instant eventDateTime) {
        if (eventDateTime == null) {
            throw new NullPointerException("eventDateTime is marked non-null but is null");
        }
        this.eventDateTime = eventDateTime;
    }

    @NonNull
    public EventOutcomeIndicator getEventOutcomeIndicator() {
        return this.eventOutcomeIndicator;
    }

    public void setEventOutcomeIndicator(@NonNull EventOutcomeIndicator eventOutcomeIndicator) {
        if (eventOutcomeIndicator == null) {
            throw new NullPointerException("eventOutcomeIndicator is marked non-null but is null");
        }
        this.eventOutcomeIndicator = eventOutcomeIndicator;
    }

    public String getEventOutcomeDescription() {
        return this.eventOutcomeDescription;
    }

    public void setEventOutcomeDescription(String eventOutcomeDescription) {
        this.eventOutcomeDescription = eventOutcomeDescription;
    }

    public EventActionCode getEventActionCode() {
        return this.eventActionCode;
    }

    public void setEventActionCode(EventActionCode eventActionCode) {
        this.eventActionCode = eventActionCode;
    }
}

