/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.model;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import lombok.NonNull;
import org.openehealth.ipf.commons.audit.codes.NetworkAccessPointTypeCode;
import org.openehealth.ipf.commons.audit.model.Validateable;
import org.openehealth.ipf.commons.audit.types.ActiveParticipantRoleId;
import org.openehealth.ipf.commons.audit.types.MediaType;

public class ActiveParticipantType
implements Serializable,
Validateable {
    private boolean userIsRequestor;
    @NonNull
    private String userID;
    private String alternativeUserID;
    private String userName;
    private String networkAccessPointID;
    private NetworkAccessPointTypeCode networkAccessPointTypeCode;
    private List<ActiveParticipantRoleId> roleIDCodes;
    private String mediaIdentifier;
    private MediaType mediaType;

    public ActiveParticipantType(String userId, boolean userIsRequestor) {
        this.userID = Objects.requireNonNull(userId, "userId must be not null");
        this.userIsRequestor = userIsRequestor;
    }

    public List<ActiveParticipantRoleId> getRoleIDCodes() {
        if (this.roleIDCodes == null) {
            this.roleIDCodes = new ArrayList<ActiveParticipantRoleId>();
        }
        return this.roleIDCodes;
    }

    @Override
    public void validate() {
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (!(o instanceof ActiveParticipantType)) {
            return false;
        }
        ActiveParticipantType other = (ActiveParticipantType)o;
        if (!other.canEqual(this)) {
            return false;
        }
        if (this.isUserIsRequestor() != other.isUserIsRequestor()) {
            return false;
        }
        String this$userID = this.getUserID();
        String other$userID = other.getUserID();
        if (this$userID == null ? other$userID != null : !this$userID.equals(other$userID)) {
            return false;
        }
        String this$alternativeUserID = this.getAlternativeUserID();
        String other$alternativeUserID = other.getAlternativeUserID();
        if (this$alternativeUserID == null ? other$alternativeUserID != null : !this$alternativeUserID.equals(other$alternativeUserID)) {
            return false;
        }
        String this$userName = this.getUserName();
        String other$userName = other.getUserName();
        if (this$userName == null ? other$userName != null : !this$userName.equals(other$userName)) {
            return false;
        }
        String this$networkAccessPointID = this.getNetworkAccessPointID();
        String other$networkAccessPointID = other.getNetworkAccessPointID();
        if (this$networkAccessPointID == null ? other$networkAccessPointID != null : !this$networkAccessPointID.equals(other$networkAccessPointID)) {
            return false;
        }
        NetworkAccessPointTypeCode this$networkAccessPointTypeCode = this.getNetworkAccessPointTypeCode();
        NetworkAccessPointTypeCode other$networkAccessPointTypeCode = other.getNetworkAccessPointTypeCode();
        if (this$networkAccessPointTypeCode == null ? other$networkAccessPointTypeCode != null : !this$networkAccessPointTypeCode.equals(other$networkAccessPointTypeCode)) {
            return false;
        }
        List<ActiveParticipantRoleId> this$roleIDCodes = this.getRoleIDCodes();
        List<ActiveParticipantRoleId> other$roleIDCodes = other.getRoleIDCodes();
        if (this$roleIDCodes == null ? other$roleIDCodes != null : !((Object)this$roleIDCodes).equals(other$roleIDCodes)) {
            return false;
        }
        String this$mediaIdentifier = this.getMediaIdentifier();
        String other$mediaIdentifier = other.getMediaIdentifier();
        if (this$mediaIdentifier == null ? other$mediaIdentifier != null : !this$mediaIdentifier.equals(other$mediaIdentifier)) {
            return false;
        }
        MediaType this$mediaType = this.getMediaType();
        MediaType other$mediaType = other.getMediaType();
        return !(this$mediaType == null ? other$mediaType != null : !this$mediaType.equals(other$mediaType));
    }

    protected boolean canEqual(Object other) {
        return other instanceof ActiveParticipantType;
    }

    public int hashCode() {
        int PRIME = 59;
        int result = 1;
        result = result * 59 + (this.isUserIsRequestor() ? 79 : 97);
        String $userID = this.getUserID();
        result = result * 59 + ($userID == null ? 43 : $userID.hashCode());
        String $alternativeUserID = this.getAlternativeUserID();
        result = result * 59 + ($alternativeUserID == null ? 43 : $alternativeUserID.hashCode());
        String $userName = this.getUserName();
        result = result * 59 + ($userName == null ? 43 : $userName.hashCode());
        String $networkAccessPointID = this.getNetworkAccessPointID();
        result = result * 59 + ($networkAccessPointID == null ? 43 : $networkAccessPointID.hashCode());
        NetworkAccessPointTypeCode $networkAccessPointTypeCode = this.getNetworkAccessPointTypeCode();
        result = result * 59 + ($networkAccessPointTypeCode == null ? 43 : $networkAccessPointTypeCode.hashCode());
        List<ActiveParticipantRoleId> $roleIDCodes = this.getRoleIDCodes();
        result = result * 59 + ($roleIDCodes == null ? 43 : ((Object)$roleIDCodes).hashCode());
        String $mediaIdentifier = this.getMediaIdentifier();
        result = result * 59 + ($mediaIdentifier == null ? 43 : $mediaIdentifier.hashCode());
        MediaType $mediaType = this.getMediaType();
        result = result * 59 + ($mediaType == null ? 43 : $mediaType.hashCode());
        return result;
    }

    public boolean isUserIsRequestor() {
        return this.userIsRequestor;
    }

    public void setUserIsRequestor(boolean userIsRequestor) {
        this.userIsRequestor = userIsRequestor;
    }

    @NonNull
    public String getUserID() {
        return this.userID;
    }

    public void setUserID(@NonNull String userID) {
        if (userID == null) {
            throw new NullPointerException("userID is marked non-null but is null");
        }
        this.userID = userID;
    }

    public String getAlternativeUserID() {
        return this.alternativeUserID;
    }

    public void setAlternativeUserID(String alternativeUserID) {
        this.alternativeUserID = alternativeUserID;
    }

    public String getUserName() {
        return this.userName;
    }

    public void setUserName(String userName) {
        this.userName = userName;
    }

    public String getNetworkAccessPointID() {
        return this.networkAccessPointID;
    }

    public void setNetworkAccessPointID(String networkAccessPointID) {
        this.networkAccessPointID = networkAccessPointID;
    }

    public NetworkAccessPointTypeCode getNetworkAccessPointTypeCode() {
        return this.networkAccessPointTypeCode;
    }

    public void setNetworkAccessPointTypeCode(NetworkAccessPointTypeCode networkAccessPointTypeCode) {
        this.networkAccessPointTypeCode = networkAccessPointTypeCode;
    }

    public String getMediaIdentifier() {
        return this.mediaIdentifier;
    }

    public void setMediaIdentifier(String mediaIdentifier) {
        this.mediaIdentifier = mediaIdentifier;
    }

    public MediaType getMediaType() {
        return this.mediaType;
    }

    public void setMediaType(MediaType mediaType) {
        this.mediaType = mediaType;
    }
}

