/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.event;

import java.util.Collections;
import java.util.Objects;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.codes.ActiveParticipantRoleIdCode;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventIdCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.NetworkAccessPointTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectIdTypeCode;
import org.openehealth.ipf.commons.audit.event.BaseAuditMessageBuilder;
import org.openehealth.ipf.commons.audit.types.EventId;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.MediaType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;

public class DataExportBuilder
extends BaseAuditMessageBuilder<DataExportBuilder> {
    public DataExportBuilder(EventOutcomeIndicator outcome, EventType eventType, PurposeOfUse ... purposesOfUse) {
        this(outcome, null, eventType, purposesOfUse);
    }

    public DataExportBuilder(EventOutcomeIndicator outcome, String eventOutcomeDescription, EventType eventType, PurposeOfUse ... purposesOfUse) {
        this(outcome, eventOutcomeDescription, EventActionCode.Read, eventType, purposesOfUse);
    }

    public DataExportBuilder(EventOutcomeIndicator outcome, String eventOutcomeDescription, EventActionCode eventActionCode, EventType eventType, PurposeOfUse ... purposesOfUse) {
        this.setEventIdentification(outcome, eventOutcomeDescription, eventActionCode, (EventId)EventIdCode.Export, eventType, purposesOfUse);
    }

    public DataExportBuilder addReceivingParticipant(String userId, String altUserId, String userName, String networkAccessPointId, boolean userIsRequestor) {
        return (DataExportBuilder)this.addDestinationActiveParticipant(userId, altUserId, userName, networkAccessPointId, userIsRequestor);
    }

    public DataExportBuilder addExportingParticipant(String userId, String altUserId, String userName, String networkAccessPointId, boolean userIsRequestor) {
        return (DataExportBuilder)this.addSourceActiveParticipant(userId, altUserId, userName, networkAccessPointId, userIsRequestor);
    }

    public DataExportBuilder setDestinationMediaParticipant(String userId, String altUserId, String userName, String networkAccessPointId, NetworkAccessPointTypeCode networkAccessPointTypeCode, String mediaIdentifier, MediaType mediaType) {
        return (DataExportBuilder)this.addActiveParticipant(userId, altUserId, userName, false, Collections.singletonList(ActiveParticipantRoleIdCode.DestinationMedia), networkAccessPointId, networkAccessPointTypeCode, mediaIdentifier, Objects.requireNonNull(mediaType));
    }

    @Override
    public void validate() {
        super.validate();
        int sources = this.getMessage().findActiveParticipants(ap -> ap.getRoleIDCodes().contains(ActiveParticipantRoleIdCode.Source)).size();
        if (sources < 1 || sources > 2) {
            throw new AuditException("Must have one or two ActiveParticipant with RoleIDCode Source");
        }
        if (this.getMessage().findActiveParticipants(ap -> ap.getRoleIDCodes().contains(ActiveParticipantRoleIdCode.DestinationMedia)).size() != 1) {
            throw new AuditException("Must have one ActiveParticipant with RoleIDCode DestinationMedia");
        }
        if (this.getMessage().findParticipantObjectIdentifications(poi -> poi.getParticipantObjectIDTypeCode() == ParticipantObjectIdTypeCode.PatientNumber).isEmpty()) {
            throw new AuditException("Must one or more ParticipantObjectIdentification with ParticipantObjectIDTypeCode PatientNumber");
        }
    }
}

