/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.event;

import java.util.Collections;
import org.openehealth.ipf.commons.audit.AuditException;
import org.openehealth.ipf.commons.audit.codes.ActiveParticipantRoleIdCode;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventIdCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectIdTypeCode;
import org.openehealth.ipf.commons.audit.event.BaseAuditMessageBuilder;
import org.openehealth.ipf.commons.audit.types.EventId;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;

public class BeginTransferringDicomInstancesBuilder
extends BaseAuditMessageBuilder<BeginTransferringDicomInstancesBuilder> {
    public BeginTransferringDicomInstancesBuilder(EventOutcomeIndicator outcome, String eventOutcomeDescription, EventType eventType, PurposeOfUse ... purposesOfUse) {
        this.setEventIdentification(outcome, eventOutcomeDescription, EventActionCode.Execute, (EventId)EventIdCode.BeginTransferringDICOMInstances, eventType, purposesOfUse);
    }

    public BeginTransferringDicomInstancesBuilder setSendingProcessParticipant(String userId, String altUserId, String userName, String networkId, boolean userIsRequestor) {
        return (BeginTransferringDicomInstancesBuilder)this.addSourceActiveParticipant(userId, altUserId, userName, networkId, userIsRequestor);
    }

    public BeginTransferringDicomInstancesBuilder setReceivingProcessParticipant(String userId, String altUserId, String userName, String networkId, boolean userIsRequestor) {
        return (BeginTransferringDicomInstancesBuilder)this.addDestinationActiveParticipant(userId, altUserId, userName, networkId, userIsRequestor);
    }

    public BeginTransferringDicomInstancesBuilder setPatientParticipantObject(String patientId, String patientName) {
        if (patientId != null) {
            this.addPatientParticipantObject(patientId, patientName, Collections.emptyList(), null);
        }
        return (BeginTransferringDicomInstancesBuilder)this.self();
    }

    public BeginTransferringDicomInstancesBuilder addTransferredStudyParticipantObject(String studyId, String uids) {
        return (BeginTransferringDicomInstancesBuilder)this.addStudyParticipantObject(studyId, Collections.singletonList(this.getTypeValuePair("ContainsSOPClass", uids)));
    }

    @Override
    public void validate() {
        super.validate();
        if (this.getMessage().findActiveParticipants(ap -> ap.getRoleIDCodes().contains(ActiveParticipantRoleIdCode.Source)).size() != 1) {
            throw new AuditException("Must have one ActiveParticipant with RoleIDCode Source");
        }
        if (this.getMessage().findActiveParticipants(ap -> ap.getRoleIDCodes().contains(ActiveParticipantRoleIdCode.Destination)).size() != 1) {
            throw new AuditException("Must have one ActiveParticipant with RoleIDCode Destination");
        }
        if (this.getMessage().findParticipantObjectIdentifications(poi -> poi.getParticipantObjectIDTypeCode() == ParticipantObjectIdTypeCode.PatientNumber).size() != 1) {
            throw new AuditException("Must have one ParticipantObjectIdentification with ParticipantObjectIDTypeCode PatientNumber");
        }
        if (this.getMessage().findParticipantObjectIdentifications(poi -> poi.getParticipantObjectIDTypeCode() == ParticipantObjectIdTypeCode.StudyInstanceUID).isEmpty()) {
            throw new AuditException("Must have one or more ParticipantObjectIdentification with ParticipantObjectIDTypeCode StudyInstanceUID");
        }
    }
}

