/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.event;

import java.time.Instant;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.codes.ActiveParticipantRoleIdCode;
import org.openehealth.ipf.commons.audit.codes.EventActionCode;
import org.openehealth.ipf.commons.audit.codes.EventOutcomeIndicator;
import org.openehealth.ipf.commons.audit.codes.NetworkAccessPointTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectDataLifeCycle;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectIdTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCode;
import org.openehealth.ipf.commons.audit.codes.ParticipantObjectTypeCodeRole;
import org.openehealth.ipf.commons.audit.event.AuditMessageBuilder;
import org.openehealth.ipf.commons.audit.model.ActiveParticipantType;
import org.openehealth.ipf.commons.audit.model.AuditMessage;
import org.openehealth.ipf.commons.audit.model.AuditSourceIdentificationType;
import org.openehealth.ipf.commons.audit.model.DicomObjectDescriptionType;
import org.openehealth.ipf.commons.audit.model.EventIdentificationType;
import org.openehealth.ipf.commons.audit.model.ParticipantObjectIdentificationType;
import org.openehealth.ipf.commons.audit.model.TypeValuePairType;
import org.openehealth.ipf.commons.audit.types.ActiveParticipantRoleId;
import org.openehealth.ipf.commons.audit.types.AuditSource;
import org.openehealth.ipf.commons.audit.types.EventId;
import org.openehealth.ipf.commons.audit.types.EventType;
import org.openehealth.ipf.commons.audit.types.MediaType;
import org.openehealth.ipf.commons.audit.types.ParticipantObjectIdType;
import org.openehealth.ipf.commons.audit.types.PurposeOfUse;

public abstract class BaseAuditMessageBuilder<T extends BaseAuditMessageBuilder<T>>
implements AuditMessageBuilder<T> {
    private static final Pattern IPV4 = Pattern.compile("^(?:[0-9]{1,3}\\.){3}[0-9]{1,3}$");
    private static final Pattern IPV6 = Pattern.compile("^(?:[A-F0-9]{1,4}:){7}[A-F0-9]{1,4}$", 2);
    private final AuditMessage auditMessage = new AuditMessage();

    @Override
    public void validate() {
        this.auditMessage.validate();
    }

    @Override
    public AuditMessage getMessage() {
        return this.auditMessage;
    }

    public T setAuditSource(String sourceId) {
        return this.setAuditSource(sourceId, null);
    }

    public T setAuditSource(String sourceId, String enterpriseSiteId) {
        return this.setAuditSource(sourceId, enterpriseSiteId, null);
    }

    public T setAuditSource(String sourceId, String enterpriseSiteId, AuditSource ... typeCodes) {
        return this.setAuditSourceIdentification(sourceId, enterpriseSiteId, typeCodes);
    }

    public T setAuditSource(AuditContext auditContext) {
        return this.setAuditSourceIdentification(auditContext.getAuditSourceId(), auditContext.getAuditEnterpriseSiteId(), auditContext.getAuditSource());
    }

    public T setEventIdentification(EventOutcomeIndicator outcome, String eventOutcomeDescription, EventActionCode action, EventId id, EventType type, PurposeOfUse ... purposesOfUse) {
        return this.setEventIdentification(outcome, eventOutcomeDescription, action, id, type, purposesOfUse != null ? Arrays.asList(purposesOfUse) : Collections.emptyList());
    }

    public T setEventIdentification(EventOutcomeIndicator outcome, String eventOutcomeDescription, EventActionCode action, EventId id, EventType type, Collection<PurposeOfUse> purposesOfUse) {
        EventIdentificationType eventIdentification = new EventIdentificationType(id, Instant.now(), outcome);
        eventIdentification.setEventActionCode(action);
        eventIdentification.setEventOutcomeDescription(eventOutcomeDescription);
        if (type != null) {
            eventIdentification.getEventTypeCode().add(type);
        }
        if (purposesOfUse != null) {
            purposesOfUse.stream().filter(Objects::nonNull).forEach(pou -> eventIdentification.getPurposesOfUse().add((PurposeOfUse)pou));
        }
        this.auditMessage.setEventIdentification(eventIdentification);
        return (T)((BaseAuditMessageBuilder)this.self());
    }

    public T setAuditSourceIdentification(String sourceID, String enterpriseSiteID, AuditSource ... typeCodes) {
        return this.setAuditSourceIdentification(sourceID, enterpriseSiteID, typeCodes != null ? Arrays.asList(typeCodes) : Collections.emptyList());
    }

    public T setAuditSourceIdentification(String sourceID, String enterpriseSiteID, Collection<AuditSource> typeCodes) {
        AuditSourceIdentificationType asi = new AuditSourceIdentificationType(sourceID);
        if (typeCodes != null) {
            typeCodes.stream().filter(Objects::nonNull).forEach(typeCode -> asi.getAuditSourceType().add((AuditSource)typeCode));
        }
        asi.setAuditEnterpriseSiteID(enterpriseSiteID);
        return this.setAuditSourceIdentification(asi);
    }

    public T setAuditSourceIdentification(AuditSourceIdentificationType auditSourceIdentificationType) {
        this.auditMessage.setAuditSourceIdentification(auditSourceIdentificationType);
        return (T)((BaseAuditMessageBuilder)this.self());
    }

    public T addSourceActiveParticipant(String userId, String altUserId, String userName, String networkId, boolean isRequestor) {
        return this.addActiveParticipant(userId, altUserId, userName, isRequestor, Collections.singletonList(ActiveParticipantRoleIdCode.Source), networkId);
    }

    public T addDestinationActiveParticipant(String userId, String altUserId, String userName, String networkAccessPointId, boolean userIsRequestor) {
        return this.addActiveParticipant(userId, altUserId, userName, userIsRequestor, Collections.singletonList(ActiveParticipantRoleIdCode.Destination), networkAccessPointId);
    }

    public T addActiveParticipant(String userID, String altUserID, String userName, Boolean userIsRequestor, List<ActiveParticipantRoleId> roleIdCodes, String networkAccessPointID) {
        return this.addActiveParticipant(userID, altUserID, userName, userIsRequestor, roleIdCodes, networkAccessPointID, this.getNetworkAccessPointCodeFromAddress(networkAccessPointID), null, null);
    }

    public T addActiveParticipant(String userID, String altUserID, String userName, Boolean userIsRequestor, List<ActiveParticipantRoleId> roleIdCodes, String networkAccessPointID, NetworkAccessPointTypeCode networkAccessPointTypeCode, String mediaIdentifier, MediaType mediaType) {
        ActiveParticipantType ap = new ActiveParticipantType(userID, userIsRequestor);
        ap.setAlternativeUserID(altUserID);
        ap.setUserName(userName);
        if (roleIdCodes != null) {
            roleIdCodes.stream().filter(Objects::nonNull).forEach(roleId -> ap.getRoleIDCodes().add((ActiveParticipantRoleId)roleId));
        }
        ap.setNetworkAccessPointID(networkAccessPointID);
        ap.setNetworkAccessPointTypeCode(networkAccessPointTypeCode);
        ap.setMediaIdentifier(mediaIdentifier);
        ap.setMediaType(mediaType);
        return this.addActiveParticipant(ap);
    }

    public T addActiveParticipant(ActiveParticipantType activeParticipantType) {
        this.auditMessage.getActiveParticipants().add(activeParticipantType);
        return (T)((BaseAuditMessageBuilder)this.self());
    }

    public T addPatientParticipantObject(String patientId, String patientName, List<TypeValuePairType> details, ParticipantObjectDataLifeCycle lifecycle) {
        return this.addParticipantObjectIdentification(ParticipantObjectIdTypeCode.PatientNumber, patientName, null, details, Objects.requireNonNull(patientId, "patient ID must be not null"), ParticipantObjectTypeCode.Person, ParticipantObjectTypeCodeRole.Patient, lifecycle, null);
    }

    public T addStudyParticipantObject(String studyId, List<TypeValuePairType> objectDetails) {
        DicomObjectDescriptionType dicomObjectDescriptionType = new DicomObjectDescriptionType();
        dicomObjectDescriptionType.getStudyIDs().add(studyId);
        return this.addParticipantObjectIdentification(ParticipantObjectIdTypeCode.StudyInstanceUID, studyId, null, objectDetails, studyId, ParticipantObjectTypeCode.System, ParticipantObjectTypeCodeRole.Report, null, null, Collections.singletonList(dicomObjectDescriptionType));
    }

    public T addParticipantObjectIdentification(ParticipantObjectIdType objectIDTypeCode, String objectName, byte[] objectQuery, List<TypeValuePairType> objectDetails, String objectID, ParticipantObjectTypeCode objectTypeCode, ParticipantObjectTypeCodeRole objectTypeCodeRole, ParticipantObjectDataLifeCycle objectDataLifeCycle, String objectSensitivity) {
        return this.addParticipantObjectIdentification(objectIDTypeCode, objectName, objectQuery, objectDetails, objectID, objectTypeCode, objectTypeCodeRole, objectDataLifeCycle, objectSensitivity, Collections.emptyList());
    }

    public T addParticipantObjectIdentification(ParticipantObjectIdType objectIDTypeCode, String objectName, byte[] objectQuery, List<TypeValuePairType> objectDetails, String objectID, ParticipantObjectTypeCode objectTypeCode, ParticipantObjectTypeCodeRole objectTypeCodeRole, ParticipantObjectDataLifeCycle objectDataLifeCycle, String objectSensitivity, List<DicomObjectDescriptionType> dicomDescriptions) {
        ParticipantObjectIdentificationType poit = new ParticipantObjectIdentificationType(objectID, objectIDTypeCode);
        poit.setParticipantObjectName(objectName);
        poit.setParticipantObjectQuery(objectQuery);
        if (null != objectDetails) {
            objectDetails.stream().filter(Objects::nonNull).forEach(objectDetail -> poit.getParticipantObjectDetails().add((TypeValuePairType)objectDetail));
        }
        poit.setParticipantObjectTypeCode(objectTypeCode);
        poit.setParticipantObjectTypeCodeRole(objectTypeCodeRole);
        poit.setParticipantObjectDataLifeCycle(objectDataLifeCycle);
        poit.setParticipantObjectSensitivity(objectSensitivity);
        if (null != dicomDescriptions) {
            dicomDescriptions.stream().filter(Objects::nonNull).forEach(description -> poit.getParticipantObjectDescriptions().add((DicomObjectDescriptionType)description));
        }
        return this.addParticipantObjectIdentification(poit);
    }

    public T addParticipantObjectIdentification(ParticipantObjectIdentificationType poit) {
        this.auditMessage.getParticipantObjectIdentifications().add(poit);
        return (T)((BaseAuditMessageBuilder)this.self());
    }

    protected NetworkAccessPointTypeCode getNetworkAccessPointCodeFromAddress(String address) {
        if (address == null) {
            return null;
        }
        return IPV4.matcher(address).matches() || IPV6.matcher(address).matches() ? NetworkAccessPointTypeCode.IPAddress : NetworkAccessPointTypeCode.MachineName;
    }
}

