/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit.codes;

import org.openehealth.ipf.commons.audit.types.EnumeratedCodedValue;
import org.openehealth.ipf.commons.audit.types.EnumeratedValueSet;
import org.openehealth.ipf.commons.audit.types.EventType;

public enum EventTypeCode implements EventType,
EnumeratedCodedValue<EventType>
{
    ApplicationStart("110120", "Application Start"),
    ApplicationStop("110121", "Application Stop"),
    Login("110122", "Login"),
    Logout("110123", "Logout"),
    Attach("110124", "Attach"),
    Detach("110125", "Detach"),
    NodeAuthentication("110126", "Node Authentication"),
    EmergencyOverrideStarted("110127", "Emergency Override Started"),
    NetworkConfiguration("110128", "Network Configuration"),
    SecurityConfiguration("110129", "Security Configuration"),
    HardwareConfiguration("110130", "Hardware Configuration"),
    SoftwareConfiguration("110131", "Software Configuration"),
    UseOfRestrictedFunction("110132", "Use of Restricted Function"),
    AuditRecordingStopped("110133", "Audit Recording Stopped"),
    AuditRecordingStarted("110134", "Audit Recording Started"),
    ObjectSecurityAttributesChanged("110135", "Object Security Attributes Changed"),
    SecurityRolesChanged("110136", "Security Roles Changed"),
    UserSecurityAttributesChanged("110137", "User Security Attributes Changed"),
    EmergencyOverrideStopped("110138", "Emergency Override Stopped"),
    RemoteServiceOperationStarted("110139", "Remote Service Operation Started"),
    RemoteServiceOperationStopped("110140", "Remote Service Operation Stopped"),
    LocalServiceOperationStarted("110141", "Local Service Operation Started"),
    LocalServiceOperationStopped("110142", "Local Service Operation Stopped"),
    AuthenticationDecision("110143", "Authentication Decision"),
    AuthorizationDecision("110144", "Authorization Decision"),
    SessionStart("110145", "Session start"),
    SessionStop("110146", "Session stop"),
    AccessControlDecision("110147", "Access Control Decision"),
    StudyInstanceUID("110180", "Study Instance UID"),
    SOPClassUID("110181", "SOP Class UID"),
    NodeID("110182", "Node ID");

    private final EventType value;

    private EventTypeCode(String code, String displayName) {
        this.value = EventType.of(code, "DCM", displayName);
    }

    public static EventTypeCode enumForCode(String code) {
        return EnumeratedValueSet.enumForCode(EventTypeCode.class, code);
    }

    @Override
    public EventType getValue() {
        return this.value;
    }
}

