/*
 * Decompiled with CFR 0.152.
 */
package org.openehealth.ipf.commons.audit;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.openehealth.ipf.commons.audit.AuditContext;
import org.openehealth.ipf.commons.audit.AuditMessagePostProcessor;
import org.openehealth.ipf.commons.audit.AuditMetadataProvider;
import org.openehealth.ipf.commons.audit.TlsParameters;
import org.openehealth.ipf.commons.audit.codes.AuditSourceType;
import org.openehealth.ipf.commons.audit.handler.AuditExceptionHandler;
import org.openehealth.ipf.commons.audit.handler.LoggingAuditExceptionHandler;
import org.openehealth.ipf.commons.audit.marshal.SerializationStrategy;
import org.openehealth.ipf.commons.audit.marshal.dicom.Current;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionChannel;
import org.openehealth.ipf.commons.audit.protocol.AuditTransmissionProtocol;
import org.openehealth.ipf.commons.audit.protocol.UDPSyslogSenderImpl;
import org.openehealth.ipf.commons.audit.queue.AuditMessageQueue;
import org.openehealth.ipf.commons.audit.queue.SynchronousAuditMessageQueue;
import org.openehealth.ipf.commons.audit.types.AuditSource;

public class DefaultAuditContext
implements AuditContext {
    static final AuditContext NO_AUDIT = new DefaultAuditContext();
    private String auditRepositoryHostName = "localhost";
    private int auditRepositoryPort = 514;
    private boolean auditEnabled = false;
    private AuditTransmissionProtocol auditTransmissionProtocol = new UDPSyslogSenderImpl();
    private AuditMessageQueue auditMessageQueue = new SynchronousAuditMessageQueue();
    private String auditSourceId = "IPF";
    private String auditEnterpriseSiteId = "IPF";
    private AuditSource auditSource = AuditSourceType.Other;
    private SerializationStrategy serializationStrategy = new Current();
    private AuditMessagePostProcessor auditMessagePostProcessor = AuditMessagePostProcessor.noOp();
    private AuditExceptionHandler auditExceptionHandler = new LoggingAuditExceptionHandler();
    private AuditMetadataProvider auditMetadataProvider = AuditMetadataProvider.getDefault();
    private TlsParameters tlsParameters = TlsParameters.getDefault();
    private boolean includeParticipantsFromResponse = false;
    private String auditValueIfMissing = "UNKNOWN";

    public String getAuditRepositoryTransport() {
        return this.auditTransmissionProtocol.getTransportName();
    }

    public void setAuditRepositoryHost(String host) {
        this.setAuditRepositoryHostName(host);
    }

    public void setAuditRepositoryTransport(String transport) {
        this.setAuditTransmissionProtocol(AuditTransmissionChannel.fromProtocolName(transport).makeInstance(this.tlsParameters));
    }

    @Override
    public String getSendingApplication() {
        return this.getAuditMetadataProvider().getSendingApplication();
    }

    public void setSendingApplication(String sendingApplication) {
        this.getAuditMetadataProvider().setSendingApplication(sendingApplication);
    }

    @Override
    public InetAddress getAuditRepositoryAddress() {
        try {
            return InetAddress.getByName(this.auditRepositoryHostName);
        }
        catch (UnknownHostException e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public String getAuditRepositoryHostName() {
        return this.auditRepositoryHostName;
    }

    public void setAuditRepositoryHostName(String auditRepositoryHostName) {
        this.auditRepositoryHostName = auditRepositoryHostName;
    }

    @Override
    public int getAuditRepositoryPort() {
        return this.auditRepositoryPort;
    }

    public void setAuditRepositoryPort(int auditRepositoryPort) {
        this.auditRepositoryPort = auditRepositoryPort;
    }

    @Override
    public boolean isAuditEnabled() {
        return this.auditEnabled;
    }

    @Override
    public void setAuditEnabled(boolean auditEnabled) {
        this.auditEnabled = auditEnabled;
    }

    @Override
    public AuditTransmissionProtocol getAuditTransmissionProtocol() {
        return this.auditTransmissionProtocol;
    }

    public void setAuditTransmissionProtocol(AuditTransmissionProtocol auditTransmissionProtocol) {
        this.auditTransmissionProtocol = auditTransmissionProtocol;
    }

    @Override
    public AuditMessageQueue getAuditMessageQueue() {
        return this.auditMessageQueue;
    }

    public void setAuditMessageQueue(AuditMessageQueue auditMessageQueue) {
        this.auditMessageQueue = auditMessageQueue;
    }

    @Override
    public String getAuditSourceId() {
        return this.auditSourceId;
    }

    public void setAuditSourceId(String auditSourceId) {
        this.auditSourceId = auditSourceId;
    }

    @Override
    public String getAuditEnterpriseSiteId() {
        return this.auditEnterpriseSiteId;
    }

    public void setAuditEnterpriseSiteId(String auditEnterpriseSiteId) {
        this.auditEnterpriseSiteId = auditEnterpriseSiteId;
    }

    @Override
    public AuditSource getAuditSource() {
        return this.auditSource;
    }

    public void setAuditSource(AuditSource auditSource) {
        this.auditSource = auditSource;
    }

    @Override
    public SerializationStrategy getSerializationStrategy() {
        return this.serializationStrategy;
    }

    public void setSerializationStrategy(SerializationStrategy serializationStrategy) {
        this.serializationStrategy = serializationStrategy;
    }

    @Override
    public AuditMessagePostProcessor getAuditMessagePostProcessor() {
        return this.auditMessagePostProcessor;
    }

    public void setAuditMessagePostProcessor(AuditMessagePostProcessor auditMessagePostProcessor) {
        this.auditMessagePostProcessor = auditMessagePostProcessor;
    }

    @Override
    public AuditExceptionHandler getAuditExceptionHandler() {
        return this.auditExceptionHandler;
    }

    public void setAuditExceptionHandler(AuditExceptionHandler auditExceptionHandler) {
        this.auditExceptionHandler = auditExceptionHandler;
    }

    @Override
    public AuditMetadataProvider getAuditMetadataProvider() {
        return this.auditMetadataProvider;
    }

    public void setAuditMetadataProvider(AuditMetadataProvider auditMetadataProvider) {
        this.auditMetadataProvider = auditMetadataProvider;
    }

    @Override
    public TlsParameters getTlsParameters() {
        return this.tlsParameters;
    }

    public void setTlsParameters(TlsParameters tlsParameters) {
        this.tlsParameters = tlsParameters;
    }

    @Override
    public boolean isIncludeParticipantsFromResponse() {
        return this.includeParticipantsFromResponse;
    }

    public void setIncludeParticipantsFromResponse(boolean includeParticipantsFromResponse) {
        this.includeParticipantsFromResponse = includeParticipantsFromResponse;
    }

    @Override
    public String getAuditValueIfMissing() {
        return this.auditValueIfMissing;
    }

    public void setAuditValueIfMissing(String auditValueIfMissing) {
        this.auditValueIfMissing = auditValueIfMissing;
    }
}

