/*
 * Decompiled with CFR 0.152.
 */
package com.atlassian.maven.plugin.clover;

import com.atlassian.clover.CloverMerge;
import com.atlassian.clover.cfg.Interval;
import com.atlassian.maven.plugin.clover.internal.AbstractCloverMojo;
import java.io.File;
import java.util.ArrayList;
import java.util.List;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugins.annotations.Mojo;
import org.apache.maven.plugins.annotations.Parameter;
import org.apache.maven.project.MavenProject;

@Mojo(name="aggregate", aggregator=true)
public class CloverAggregateMojo
extends AbstractCloverMojo {
    @Parameter(property="maven.clover.span")
    private String span = Interval.DEFAULT_SPAN.toString();

    @Override
    public void execute() throws MojoExecutionException {
        if (this.skip) {
            this.getLog().debug((CharSequence)"Skipping clover aggregate.");
            return;
        }
        if (this.getProject().getModules() != null && this.getProject().getModules().size() > 0) {
            super.execute();
            this.getLog().debug((CharSequence)("Project " + this.getProject().getId() + " (" + this.getProject().getBasedir() + ") has " + this.getProject().getModules().size() + " child modules"));
            AbstractCloverMojo.waitForFlush(this.getWaitForFlush(), this.getFlushInterval());
            List<String> childrenDatabases = this.getChildrenCloverDatabases();
            if (childrenDatabases.size() > 0) {
                new File(this.getCloverMergeDatabase()).getParentFile().mkdirs();
                this.mergeCloverDatabases(childrenDatabases);
            } else {
                this.getLog().warn((CharSequence)"No Clover databases found in children projects, no merge done. Run a build with debug logging for more details.");
            }
        }
    }

    private List<String> getChildrenCloverDatabases() {
        String resolvedCloverDb = this.resolveCloverDatabase();
        String projectBaseDir = this.getProject().getBasedir().getPath();
        this.getLog().debug((CharSequence)("Calculating relative database path of '" + resolvedCloverDb + "' against the project base directory '" + projectBaseDir + "'"));
        String relativeCloverDatabasePath = resolvedCloverDb.substring(projectBaseDir.length());
        this.getLog().debug((CharSequence)("Relative path is '" + relativeCloverDatabasePath + "'"));
        ArrayList<String> dbFiles = new ArrayList<String>();
        List<MavenProject> projects = this.getDescendantModuleProjects(this.getProject());
        for (MavenProject childProject : projects) {
            this.getLog().debug((CharSequence)("Looking for Clover database for module " + childProject.getId() + " (" + childProject.getBasedir() + ")"));
            File cloverDb = new File(childProject.getBasedir(), relativeCloverDatabasePath);
            if (cloverDb.exists()) {
                this.getLog().debug((CharSequence)("Database found at " + cloverDb.getAbsolutePath() + " . Adding for merge."));
                dbFiles.add(cloverDb.getPath());
                continue;
            }
            this.getLog().debug((CharSequence)("No database at " + cloverDb.getAbsolutePath()));
        }
        return dbFiles;
    }

    private void mergeCloverDatabases(List<String> dbFiles) throws MojoExecutionException {
        ArrayList<String> parameters = new ArrayList<String>();
        parameters.add("-s");
        parameters.add(this.span);
        parameters.add("-i");
        parameters.add(this.getCloverMergeDatabase());
        if (this.getLog().isDebugEnabled()) {
            parameters.add("-d");
        }
        parameters.addAll(dbFiles);
        int mergeResult = CloverMerge.mainImpl((String[])parameters.toArray(new String[0]));
        if (mergeResult != 0) {
            throw new MojoExecutionException("Clover has failed to merge the children module databases");
        }
    }
}

