/*
 * Decompiled with CFR 0.152.
 */
package org.junit.jupiter.engine.extension;

import java.lang.reflect.Field;
import java.lang.reflect.Member;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.ServiceLoader;
import java.util.Set;
import java.util.function.Function;
import java.util.function.Predicate;
import java.util.stream.Stream;
import org.apiguardian.api.API;
import org.jspecify.annotations.Nullable;
import org.junit.jupiter.api.extension.Extension;
import org.junit.jupiter.engine.config.JupiterConfiguration;
import org.junit.jupiter.engine.extension.AutoCloseExtension;
import org.junit.jupiter.engine.extension.DisabledCondition;
import org.junit.jupiter.engine.extension.ExtensionRegistrar;
import org.junit.jupiter.engine.extension.ExtensionRegistry;
import org.junit.jupiter.engine.extension.PreInterruptThreadDumpPrinter;
import org.junit.jupiter.engine.extension.RepeatedTestExtension;
import org.junit.jupiter.engine.extension.TempDirectory;
import org.junit.jupiter.engine.extension.TestInfoParameterResolver;
import org.junit.jupiter.engine.extension.TestReporterParameterResolver;
import org.junit.jupiter.engine.extension.TimeoutExtension;
import org.junit.platform.commons.logging.Logger;
import org.junit.platform.commons.logging.LoggerFactory;
import org.junit.platform.commons.support.ReflectionSupport;
import org.junit.platform.commons.util.ClassLoaderUtils;
import org.junit.platform.commons.util.Preconditions;
import org.junit.platform.commons.util.ServiceLoaderUtils;

@API(status=API.Status.INTERNAL, since="5.5")
public class MutableExtensionRegistry
implements ExtensionRegistry,
ExtensionRegistrar {
    private static final Logger logger = LoggerFactory.getLogger(MutableExtensionRegistry.class);
    private static final List<Extension> DEFAULT_STATELESS_EXTENSIONS = List.of(new DisabledCondition(), new AutoCloseExtension(), new TimeoutExtension(), new RepeatedTestExtension(), new TestInfoParameterResolver(), new TestReporterParameterResolver());
    private final Set<Class<? extends Extension>> registeredExtensionTypes;
    private final List<Entry> registeredExtensions;
    private final Map<Class<?>, LateInitExtensions> lateInitExtensions;

    public static MutableExtensionRegistry createRegistryWithDefaultExtensions(JupiterConfiguration configuration) {
        MutableExtensionRegistry extensionRegistry = new MutableExtensionRegistry();
        DEFAULT_STATELESS_EXTENSIONS.forEach(extensionRegistry::registerDefaultExtension);
        extensionRegistry.registerDefaultExtension((Extension)new TempDirectory(configuration));
        if (configuration.isExtensionAutoDetectionEnabled()) {
            MutableExtensionRegistry.registerAutoDetectedExtensions(extensionRegistry, configuration);
        }
        if (configuration.isThreadDumpOnTimeoutEnabled()) {
            extensionRegistry.registerDefaultExtension((Extension)new PreInterruptThreadDumpPrinter());
        }
        return extensionRegistry;
    }

    private static void registerAutoDetectedExtensions(MutableExtensionRegistry extensionRegistry, JupiterConfiguration configuration) {
        Predicate<Class<? extends Extension>> filter = configuration.getFilterForAutoDetectedExtensions();
        ArrayList<Class<? extends Extension>> excludedExtensions = new ArrayList<Class<? extends Extension>>();
        ServiceLoader<Extension> serviceLoader = ServiceLoader.load(Extension.class, ClassLoaderUtils.getDefaultClassLoader());
        ServiceLoaderUtils.filter(serviceLoader, clazz -> {
            boolean included = filter.test((Class<? extends Extension>)clazz);
            if (!included) {
                excludedExtensions.add((Class<? extends Extension>)clazz);
            }
            return included;
        }).forEach(extensionRegistry::registerAutoDetectedExtension);
        MutableExtensionRegistry.logExcludedExtensions(excludedExtensions);
    }

    private static void logExcludedExtensions(List<Class<? extends Extension>> excludedExtensions) {
        if (!excludedExtensions.isEmpty()) {
            List<String> excludeExtensionNames = excludedExtensions.stream().map(Class::getName).toList();
            logger.config(() -> "Excluded auto-detected extensions due to configured includes/excludes: %s".formatted(excludeExtensionNames));
        }
    }

    public static MutableExtensionRegistry createRegistryFrom(MutableExtensionRegistry parentRegistry, Stream<Class<? extends Extension>> extensionTypes) {
        Preconditions.notNull((Object)parentRegistry, (String)"parentRegistry must not be null");
        MutableExtensionRegistry registry = new MutableExtensionRegistry(parentRegistry);
        extensionTypes.forEach(registry::registerExtension);
        return registry;
    }

    private MutableExtensionRegistry() {
        this(Collections.emptySet(), Collections.emptyList());
    }

    private MutableExtensionRegistry(MutableExtensionRegistry parent) {
        this(parent.registeredExtensionTypes, parent.registeredExtensions);
    }

    private MutableExtensionRegistry(Set<Class<? extends Extension>> registeredExtensionTypes, List<Entry> registeredExtensions) {
        this.registeredExtensionTypes = new LinkedHashSet<Class<? extends Extension>>(registeredExtensionTypes);
        this.registeredExtensions = new ArrayList<Entry>(registeredExtensions.size());
        this.lateInitExtensions = new LinkedHashMap();
        registeredExtensions.forEach(entry -> {
            Entry newEntry = entry;
            if (entry instanceof LateInitEntry) {
                LateInitEntry lateInitEntry = (LateInitEntry)entry;
                newEntry = lateInitEntry.getExtension().map(Entry::of).orElseGet(() -> this.getLateInitExtensions(lateInitEntry.getTestClass()).add(lateInitEntry.copy()));
            }
            this.registeredExtensions.add(newEntry);
        });
    }

    @Override
    public <E extends Extension> Stream<E> stream(Class<E> extensionType) {
        return this.registeredExtensions.stream().map(p -> p.getExtension().orElse(null)).filter(extensionType::isInstance).map(extensionType::cast);
    }

    @Override
    public void registerExtension(Class<? extends Extension> extensionType) {
        if (!this.isAlreadyRegistered(extensionType)) {
            this.registerLocalExtension((Extension)ReflectionSupport.newInstance(extensionType, (Object[])new Object[0]));
        }
    }

    private boolean isAlreadyRegistered(Class<? extends Extension> extensionType) {
        return this.registeredExtensionTypes.contains(extensionType);
    }

    @Override
    public void registerExtension(Extension extension, Object source) {
        Preconditions.notNull((Object)source, (String)"source must not be null");
        this.registerExtension("local", extension, source);
    }

    @Override
    public void registerSyntheticExtension(Extension extension, Object source) {
        this.registerExtension("synthetic", extension, source);
    }

    @Override
    public void registerUninitializedExtension(Class<?> testClass, Field source, Function<Object, ? extends Extension> initializer) {
        Preconditions.notNull(testClass, (String)"testClass must not be null");
        Preconditions.notNull((Object)source, (String)"source must not be null");
        Preconditions.notNull(initializer, (String)"initializer must not be null");
        logger.trace(() -> "Registering local extension (late-init) for [%s]%s".formatted(source.getType().getName(), this.buildSourceInfo(source)));
        LateInitEntry entry = this.getLateInitExtensions(testClass).add(new LateInitEntry(testClass, initializer));
        this.registeredExtensions.add(entry);
    }

    @Override
    public void initializeExtensions(Class<?> testClass, Object testInstance) {
        Preconditions.notNull(testClass, (String)"testClass must not be null");
        Preconditions.notNull((Object)testInstance, (String)"testInstance must not be null");
        LateInitExtensions extensions = this.lateInitExtensions.remove(testClass);
        if (extensions != null) {
            extensions.initialize(testInstance);
        }
    }

    private LateInitExtensions getLateInitExtensions(Class<?> testClass) {
        return this.lateInitExtensions.computeIfAbsent(testClass, __ -> new LateInitExtensions());
    }

    private void registerDefaultExtension(Extension extension) {
        this.registerExtension("default", extension);
    }

    private void registerAutoDetectedExtension(Extension extension) {
        this.registerExtension("auto-detected", extension);
    }

    private void registerLocalExtension(Extension extension) {
        this.registerExtension("local", extension);
    }

    private void registerExtension(String category, Extension extension) {
        this.registerExtension(category, extension, null);
    }

    private void registerExtension(String category, Extension extension, @Nullable Object source) {
        Preconditions.notBlank((String)category, (String)"category must not be null or blank");
        Preconditions.notNull((Object)extension, (String)"extension must not be null");
        logger.trace(() -> "Registering %s extension [%s]%s".formatted(category, extension, this.buildSourceInfo(source)));
        this.registeredExtensions.add(Entry.of(extension));
        this.registeredExtensionTypes.add(extension.getClass());
    }

    private String buildSourceInfo(@Nullable Object source) {
        if (source == null) {
            return "";
        }
        if (source instanceof Member) {
            Member member = (Member)source;
            String type = member instanceof Method ? "method" : "field";
            source = "%s %s.%s".formatted(type, member.getDeclaringClass().getName(), member.getName());
        }
        return " from source [" + String.valueOf(source) + "]";
    }

    private static class LateInitExtensions {
        private final List<LateInitEntry> entries = new ArrayList<LateInitEntry>();

        private LateInitExtensions() {
        }

        LateInitEntry add(LateInitEntry entry) {
            this.entries.add(entry);
            return entry;
        }

        void initialize(Object testInstance) {
            this.entries.forEach(entry -> entry.initialize(testInstance));
        }
    }

    private static class LateInitEntry
    implements Entry {
        private final Class<?> testClass;
        private final Function<Object, ? extends Extension> initializer;
        private Optional<Extension> extension = Optional.empty();

        LateInitEntry(Class<?> testClass, Function<Object, ? extends Extension> initializer) {
            this.testClass = testClass;
            this.initializer = initializer;
        }

        @Override
        public Optional<Extension> getExtension() {
            return this.extension;
        }

        public Class<?> getTestClass() {
            return this.testClass;
        }

        void initialize(Object testInstance) {
            Preconditions.condition((boolean)this.extension.isEmpty(), (String)"Extension already initialized");
            this.extension = Optional.of(this.initializer.apply(testInstance));
        }

        LateInitEntry copy() {
            Preconditions.condition((boolean)this.extension.isEmpty(), (String)"Extension already initialized");
            return new LateInitEntry(this.testClass, this.initializer);
        }
    }

    private static interface Entry {
        public static Entry of(Extension extension) {
            Optional<Extension> value = Optional.of(extension);
            return () -> value;
        }

        public Optional<Extension> getExtension();
    }
}

